/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;
import java.util.HexFormat;

public class SquashOtherInode
extends SquashInode {
    private long linkCount;
    private int targetSize;
    private long xattrIndex;
    private long deviceNumber;

    public SquashOtherInode(BinaryReader reader, SquashSuperBlock superBlock, int inodeType) throws IOException {
        super(reader, superBlock);
        switch (inodeType) {
            case 4: 
            case 5: {
                this.linkCount = reader.readNextUnsignedInt();
                this.deviceNumber = reader.readNextUnsignedInt();
                break;
            }
            case 11: 
            case 12: {
                this.linkCount = reader.readNextUnsignedInt();
                this.deviceNumber = reader.readNextUnsignedInt();
                this.xattrIndex = reader.readNextUnsignedInt();
                break;
            }
            case 6: 
            case 7: {
                this.linkCount = reader.readNextUnsignedInt();
                break;
            }
            case 13: 
            case 14: {
                this.linkCount = reader.readNextUnsignedInt();
                this.xattrIndex = reader.readNextUnsignedInt();
                break;
            }
            default: {
                throw new IOException("Unknown inode type: 0x" + HexFormat.of().toHexDigits(inodeType));
            }
        }
    }

    public long getLinkCount() {
        return this.linkCount;
    }

    public int getTargetSize() {
        return this.targetSize;
    }

    public long getXattrIndex() {
        return this.xattrIndex;
    }

    public long getDeviceNumber() {
        return this.deviceNumber;
    }
}

