/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.JumpTable;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class DecompilerSwitchAnalysisCmd
extends BackgroundCommand<Program> {
    private static final int DEFAULT_CASE_VALUE = -1160664095;
    private Program program;
    private DecompileResults decompilerResults;
    protected DecompInterface decompiler;
    private boolean useArraysForSwitchTables = false;

    public DecompilerSwitchAnalysisCmd(DecompileResults decompileResults) {
        this.decompilerResults = decompileResults;
    }

    public boolean applyTo(Program p, TaskMonitor monitor) {
        this.program = p;
        if (monitor.isCancelled()) {
            return false;
        }
        this.analyzeFunction(monitor);
        return true;
    }

    private void analyzeFunction(TaskMonitor monitor) {
        block5: {
            if (!this.decompilerResults.decompileCompleted()) {
                return;
            }
            try {
                monitor.checkCancelled();
                Function f = this.decompilerResults.getFunction();
                HighFunction hfunction = this.decompilerResults.getHighFunction();
                String errMsg = this.getStatusMsg();
                if (hfunction == null) {
                    String msg = errMsg != null && errMsg.length() != 0 ? ": " + errMsg : "";
                    Msg.debug((Object)((Object)this), (Object)("  Failed to decompile function: " + f.getName() + msg));
                }
                this.processBranchIND(f, hfunction, monitor);
            }
            catch (Exception e) {
                if (monitor.isCancelled()) break block5;
                Object errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = "Error decompiling function: " + String.valueOf(e);
                }
                this.setStatusMsg((String)errMsg);
            }
        }
    }

    private void processBranchIND(Function f, HighFunction hfunction, TaskMonitor monitor) throws CancelledException {
        JumpTable[] tables;
        for (JumpTable table : tables = hfunction.getJumpTables()) {
            Function containingFunction;
            Address switchAddr = table.getSwitchAddress();
            Instruction instr = this.program.getListing().getInstructionAt(switchAddr);
            if (instr == null || (containingFunction = this.program.getFunctionManager().getFunctionContaining(switchAddr)) != null && !containingFunction.equals((Object)f) || this.hasAllReferences(monitor, table, instr, containingFunction)) continue;
            FlowType flowType = instr.getFlowType();
            if (flowType.isCall()) {
                flowType = RefType.COMPUTED_JUMP;
            } else {
                this.program.getReferenceManager().removeAllReferencesFrom(instr.getMinAddress());
            }
            this.labelSwitch(table, monitor);
            this.disassembleTable(monitor, table, instr, flowType);
            this.fixupFunction(f, monitor, instr);
        }
    }

    private void fixupFunction(Function f, TaskMonitor monitor, Instruction instr) throws CancelledException {
        Function realFunc;
        Function fixupFunc = f;
        if (fixupFunc instanceof UndefinedFunction && (realFunc = this.program.getFunctionManager().getFunctionContaining(instr.getMinAddress())) != null) {
            fixupFunc = realFunc;
        }
        Instruction funcStartInstr = this.program.getListing().getInstructionAt(fixupFunc.getEntryPoint());
        CreateFunctionCmd.fixupFunctionBody((Program)this.program, (Instruction)funcStartInstr, (TaskMonitor)monitor);
    }

    private void disassembleTable(TaskMonitor monitor, JumpTable table, Instruction instr, FlowType flowType) throws CancelledException {
        Address switchAddr = table.getSwitchAddress();
        ProgramContext programContext = this.program.getProgramContext();
        Register baseContextRegister = programContext.getBaseContextRegister();
        RegisterValue switchContext = null;
        if (baseContextRegister != null) {
            switchContext = programContext.getRegisterValue(baseContextRegister, switchAddr);
            switchContext = programContext.getFlowValue(switchContext);
        }
        Listing listing = this.program.getListing();
        Address[] cases = table.getCases();
        Integer[] caseValues = table.getLabelValues();
        AddressSet disSetList = new AddressSet();
        for (int caseIndex = 0; caseIndex < cases.length; ++caseIndex) {
            Address caseStart = cases[caseIndex];
            monitor.checkCancelled();
            if (!this.isDefaultCase(caseValues, caseIndex)) {
                instr.addMnemonicReference(caseStart, (RefType)flowType, SourceType.ANALYSIS);
            }
            if (listing.getUndefinedDataAt(caseStart) == null || disSetList.contains(caseStart)) continue;
            try {
                this.setSwitchTargetContext(programContext, caseStart, switchContext);
            }
            catch (ContextChangeException e) {
                continue;
            }
            disSetList.add(caseStart);
        }
        if (!disSetList.isEmpty()) {
            DisassembleCommand cmd = new DisassembleCommand((AddressSetView)disSetList, null, true);
            cmd.applyTo((DomainObject)this.program);
        }
    }

    private boolean isDefaultCase(Integer[] caseValues, int caseIndex) {
        return caseIndex == caseValues.length || caseIndex < caseValues.length && caseValues[caseIndex] == -1160664095;
    }

    public boolean hasAllReferences(TaskMonitor monitor, JumpTable table, Instruction instr, Function containingFunction) throws CancelledException {
        AddressSetView containingBody = containingFunction != null ? containingFunction.getBody() : null;
        Reference[] referencesFrom = instr.getReferencesFrom();
        Address[] tableDest = table.getCases();
        Integer[] caseValues = table.getLabelValues();
        for (int caseIndex = 0; caseIndex < tableDest.length; ++caseIndex) {
            monitor.checkCancelled();
            boolean isDefaultCase = this.isDefaultCase(caseValues, caseIndex);
            if (containingBody != null && !containingBody.contains(tableDest[caseIndex])) {
                return false;
            }
            boolean foundit = false;
            for (Reference element : referencesFrom) {
                if (!element.getToAddress().equals((Object)tableDest[caseIndex])) continue;
                foundit = true;
                break;
            }
            if (!(isDefaultCase ? foundit : !foundit)) continue;
            return false;
        }
        return true;
    }

    private void setSwitchTargetContext(ProgramContext programContext, Address targetStart, RegisterValue switchContext) throws ContextChangeException {
        if (switchContext == null) {
            return;
        }
        RegisterValue curContext = programContext.getNonDefaultValue(switchContext.getRegister(), targetStart);
        if (curContext != null) {
            switchContext = curContext.combineValues(switchContext);
        }
        if (switchContext == null || !switchContext.hasAnyValue()) {
            return;
        }
        this.program.getProgramContext().setRegisterValue(targetStart, targetStart, switchContext);
    }

    private void labelSwitch(JumpTable table, TaskMonitor monitor) throws CancelledException {
        JumpTable.LoadTable[] loadtable;
        Symbol[] syms;
        AddLabelCmd tableNameLabel = new AddLabelCmd(table.getSwitchAddress(), "switchD", SourceType.ANALYSIS);
        for (Symbol sym : syms = this.program.getSymbolTable().getSymbols(table.getSwitchAddress())) {
            if (!sym.getName(false).startsWith(tableNameLabel.getLabelName())) continue;
            return;
        }
        Namespace space = null;
        String switchName = "switchD_" + String.valueOf(table.getSwitchAddress());
        try {
            space = this.program.getSymbolTable().createNameSpace(null, switchName, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            space = this.program.getSymbolTable().getNamespace(switchName, null);
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        tableNameLabel.setNamespace(space);
        tableNameLabel.applyTo(this.program);
        Address[] switchCases = table.getCases();
        Integer[] caseValues = table.getLabelValues();
        Symbol[] caseSymbols = new Symbol[caseValues.length];
        SymbolTable symTable = this.program.getSymbolTable();
        for (int caseIndex = 0; caseIndex < switchCases.length; ++caseIndex) {
            AddLabelCmd lcmd;
            Symbol oldSym;
            monitor.checkCancelled();
            int caseValue = caseIndex < caseValues.length ? caseValues[caseIndex] : caseIndex;
            boolean isDefaultCase = this.isDefaultCase(caseValues, caseIndex);
            Object caseName = "caseD_" + Integer.toHexString(caseValue);
            if (isDefaultCase) {
                caseName = "default";
            }
            if ((oldSym = symTable.getPrimarySymbol((lcmd = new AddLabelCmd(switchCases[caseIndex], (String)caseName, space, SourceType.ANALYSIS)).getLabelAddr())) != null && oldSym.getSource() == SourceType.ANALYSIS && oldSym.getName().startsWith("Addr")) {
                oldSym.delete();
            }
            if (!lcmd.applyTo(this.program) || caseIndex >= caseSymbols.length) continue;
            caseSymbols[caseIndex] = symTable.getSymbol((String)caseName, switchCases[caseIndex], space);
        }
        for (JumpTable.LoadTable element : loadtable = table.getLoadTables()) {
            this.labelLoadTable(element, switchCases, caseSymbols, space, monitor);
        }
    }

    private Address[] getPointerTable(JumpTable.LoadTable loadtable, Address[] switchCases) {
        int size = loadtable.getSize();
        int num = loadtable.getNum();
        if (size > 8) {
            return null;
        }
        AddressSpace addrspace = switchCases[0].getAddressSpace();
        Address[] addresses = new Address[num];
        DataType entrydt = AbstractIntegerDataType.getUnsignedDataType((int)size, (DataTypeManager)this.program.getDataTypeManager());
        Address addr = loadtable.getAddress();
        DumbMemBufferImpl buf = new DumbMemBufferImpl(this.program.getMemory(), addr);
        for (int i = 0; i < num; ++i) {
            int tableOffset = size * i;
            Address nextAddr = addr.add((long)tableOffset);
            buf.setPosition(nextAddr);
            Scalar scalar = (Scalar)entrydt.getValue((MemBuffer)buf, SettingsImpl.NO_SETTINGS, 0);
            long unsignedOffset = scalar.getUnsignedValue() * (long)addrspace.getAddressableUnitSize();
            long signedOffset = scalar.getSignedValue() * (long)addrspace.getAddressableUnitSize();
            boolean found = false;
            for (Address caddr : switchCases) {
                long offset = caddr.getOffset();
                if (offset != unsignedOffset && offset != signedOffset) continue;
                found = true;
                addresses[i] = caddr;
                break;
            }
            if (found) continue;
            return null;
        }
        return addresses;
    }

    private void labelLoadTable(JumpTable.LoadTable loadtable, Address[] switchCases, Symbol[] caseSymbols, Namespace space, TaskMonitor monitor) throws CancelledException {
        Symbol[] syms;
        int defaultPtrSize;
        ProgramBasedDataTypeManager dtmanager = this.program.getDataTypeManager();
        Address[] pointers = this.getPointerTable(loadtable, switchCases);
        boolean usingPointers = false;
        Address tableAddr = loadtable.getAddress();
        int size = loadtable.getSize();
        int num = loadtable.getNum();
        DataType entrydt = AbstractIntegerDataType.getUnsignedDataType((int)size, (DataTypeManager)dtmanager);
        if (pointers != null && (defaultPtrSize = this.program.getDefaultPointerSize()) == size && defaultPtrSize == switchCases[0].getAddressSpace().getPointerSize()) {
            entrydt = PointerDataType.getPointer(null, (DataTypeManager)dtmanager);
            usingPointers = true;
        }
        DataType fulldt = null;
        if (num > 1 && this.useArraysForSwitchTables) {
            fulldt = new ArrayDataType(entrydt, num, size);
            num = 1;
        } else {
            fulldt = entrydt;
        }
        for (int i = 0; i < num; ++i) {
            monitor.checkCancelled();
            Address addr = tableAddr.addWrap((long)(i * size));
            Data defData = this.program.getListing().getDefinedDataAt(addr);
            if (defData != null && !Undefined.isUndefined((DataType)defData.getDataType())) continue;
            CreateDataCmd cmd = new CreateDataCmd(addr, true, fulldt);
            cmd.applyTo(this.program);
            this.markDataAsConstant(addr);
        }
        if (pointers != null && !usingPointers) {
            ReferenceManager refMgr = this.program.getReferenceManager();
            for (int i = 0; i < num; ++i) {
                monitor.checkCancelled();
                int tableOffset = size * i;
                Address addr = tableAddr.add((long)tableOffset);
                refMgr.addMemoryReference(addr, switchCases[i], RefType.DATA, SourceType.ANALYSIS, 0);
            }
        }
        String dataName = "switchdataD_" + String.valueOf(loadtable.getAddress());
        for (Symbol sym : syms = this.program.getSymbolTable().getSymbols(tableAddr)) {
            if (!sym.getName(false).startsWith(dataName)) continue;
            return;
        }
        AddLabelCmd dataNameLabel = new AddLabelCmd(tableAddr, dataName, SourceType.ANALYSIS);
        dataNameLabel.setNamespace(space);
        dataNameLabel.applyTo(this.program);
    }

    public final void markDataAsConstant(Address addr) {
        SettingsDefinition[] settings;
        Data data = this.program.getListing().getDataAt(addr);
        if (data == null) {
            return;
        }
        for (SettingsDefinition definitions : settings = data.getDataType().getSettingsDefinitions()) {
            if (!(definitions instanceof MutabilitySettingsDefinition)) continue;
            MutabilitySettingsDefinition setting = (MutabilitySettingsDefinition)definitions;
            setting.setChoice((Settings)data, 2);
        }
    }
}

