/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.decompiler.DecompileDebug;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighExternalSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighFunctionSymbol;
import ghidra.program.model.pcode.HighLabelSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PatchEncoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.pcode.XmlEncode;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.NameTransformer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class DecompileCallback {
    public static final int MAX_SYMBOL_COUNT = 16;
    private DecompileDebug debug;
    private Program program;
    private Listing listing;
    private Function cachedFunction;
    private AddressSet undefinedBody;
    private Address funcEntry;
    private int default_extrapop;
    private Language pcodelanguage;
    private CompilerSpec pcodecompilerspec;
    private AddressFactory addrfactory;
    private ConstantPool cpool;
    private PcodeDataTypeManager dtmanage;
    private String nativeMessage;
    private InstructionBlock lastPseudoInstructionBlock;
    private Disassembler pseudoDisassembler;

    public DecompileCallback(Program prog, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dt) {
        this.program = prog;
        this.pcodelanguage = language;
        this.pcodecompilerspec = compilerSpec;
        this.listing = this.program.getListing();
        this.addrfactory = this.program.getAddressFactory();
        this.dtmanage = dt;
        this.default_extrapop = this.pcodecompilerspec.getDefaultCallingConvention().getExtrapop();
        this.cpool = null;
        this.nativeMessage = null;
        this.debug = null;
    }

    public void setFunction(Function func, Address entry, DecompileDebug dbg) {
        this.cachedFunction = func;
        this.undefinedBody = null;
        if (func instanceof UndefinedFunction) {
            this.undefinedBody = new AddressSet(func.getBody());
        }
        this.funcEntry = entry;
        this.debug = dbg;
        if (this.debug != null) {
            this.debug.setPcodeDataTypeManager(this.dtmanage);
        }
        this.nativeMessage = null;
        this.lastPseudoInstructionBlock = null;
        if (this.pseudoDisassembler != null) {
            this.pseudoDisassembler.resetDisassemblerContext();
        }
    }

    public String getNativeMessage() {
        return this.nativeMessage;
    }

    void setNativeMessage(String msg) {
        this.nativeMessage = msg;
    }

    public byte[] getBytes(Address addr, int size) {
        if (addr == Address.NO_ADDRESS) {
            Msg.error((Object)this, (Object)"Address does not physically map");
            return null;
        }
        if (addr.isRegisterAddress()) {
            return null;
        }
        try {
            byte[] resbytes = new byte[size];
            int bytesRead = this.program.getMemory().getBytes(addr, resbytes, 0, size);
            if (this.debug != null) {
                if (bytesRead != size) {
                    byte[] debugBytes = new byte[bytesRead];
                    System.arraycopy(resbytes, 0, debugBytes, 0, bytesRead);
                    this.debug.getBytes(addr, debugBytes);
                } else {
                    this.debug.getBytes(addr, resbytes);
                }
            }
            return resbytes;
        }
        catch (MemoryAccessException e) {
            Msg.warn((Object)this, (Object)("Decompiling " + String.valueOf(this.funcEntry) + ": " + e.getMessage()));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + String.valueOf(this.funcEntry) + ", error while accessing bytes: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public void getComments(Address addr, int types, Encoder resultEncoder) throws IOException {
        Function func = this.getFunctionAt(addr);
        if (func == null) {
            return;
        }
        this.encodeComments(resultEncoder, addr, func, types);
        if (this.debug != null) {
            XmlEncode xmlEncode = new XmlEncode();
            this.encodeComments((Encoder)xmlEncode, addr, func, types);
            this.debug.getComments(xmlEncode.toString());
        }
    }

    public void getPcode(Address addr, PatchEncoder resultEncoder) {
        try {
            Instruction instr = this.getInstruction(addr);
            if (instr == null) {
                return;
            }
            if (this.undefinedBody != null) {
                this.undefinedBody.addRange(instr.getMinAddress(), instr.getMaxAddress());
                this.cachedFunction.setBody((AddressSetView)this.undefinedBody);
            }
            if (this.debug != null) {
                this.debug.getPcode(addr, instr);
                FlowOverride fo = instr.getFlowOverride();
                if (fo != FlowOverride.NONE) {
                    this.debug.addFlowOverride(addr, fo);
                }
            }
            instr.getPrototype().getPcodePacked(resultEncoder, instr.getInstructionContext(), (PcodeOverride)new InstructionPcodeOverride(instr));
            return;
        }
        catch (UsrException e) {
            Msg.warn((Object)this, (Object)("Decompiling " + String.valueOf(this.funcEntry) + ", pcode error at " + String.valueOf(addr) + ": " + e.getMessage()));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Decompiling " + String.valueOf(this.funcEntry) + ", pcode error at " + String.valueOf(addr) + ": " + e.getMessage()), (Throwable)e);
        }
        resultEncoder.clear();
    }

    public static void encodeInstruction(Encoder encoder, Address addr, PcodeOp[] ops, int fallthruoffset, int paramshift, AddressFactory addrFactory) throws IOException {
        if (ops.length == 1 && ops[0].getOpcode() == 0) {
            encoder.openElement(ElementId.ELEM_UNIMPL);
            encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, (long)fallthruoffset);
            encoder.closeElement(ElementId.ELEM_UNIMPL);
            return;
        }
        encoder.openElement(ElementId.ELEM_INST);
        encoder.writeSignedInteger(AttributeId.ATTRIB_OFFSET, (long)fallthruoffset);
        if (paramshift != 0) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_PARAMSHIFT, (long)paramshift);
        }
        AddressXML.encode((Encoder)encoder, (Address)addr);
        for (PcodeOp op : ops) {
            op.encodeRaw(encoder, addrFactory);
        }
        encoder.closeElement(ElementId.ELEM_INST);
    }

    public void getPcodeInject(String nm, Decoder paramDecoder, int type, Encoder resultEncoder) throws DecoderException, UnknownInstructionException, IOException, MemoryAccessException, NotFoundException {
        int fallThruOffset;
        PcodeInjectLibrary snippetLibrary = this.pcodecompilerspec.getPcodeInjectLibrary();
        InjectPayload payload = snippetLibrary.getPayload(type, nm);
        if (payload == null) {
            throw new NotFoundException("No p-code injection with name: " + nm);
        }
        InjectContext con = snippetLibrary.buildInjectContext();
        con.decode(paramDecoder);
        if (payload.getType() == 4) {
            fallThruOffset = 4;
        } else {
            Instruction instr = this.getInstruction(con.baseAddr);
            if (instr == null) {
                Msg.warn((Object)this, (Object)("Decompiling " + String.valueOf(this.funcEntry) + ", pcode inject error at " + String.valueOf(con.baseAddr) + ": instruction not found"));
                return;
            }
            fallThruOffset = instr.getDefaultFallThroughOffset();
            con.nextAddr = con.baseAddr.add((long)fallThruOffset);
            con.refAddr = null;
            for (Reference ref : this.program.getReferenceManager().getReferencesFrom(con.baseAddr)) {
                if (!ref.isPrimary() || !ref.getReferenceType().isCall()) continue;
                con.refAddr = ref.getToAddress();
                break;
            }
        }
        PcodeOp[] pcode = payload.getPcode(this.program, con);
        if (pcode == null) {
            return;
        }
        DecompileCallback.encodeInstruction(resultEncoder, con.baseAddr, pcode, fallThruOffset, payload.getParamShift(), this.addrfactory);
        if (this.debug != null) {
            XmlEncode xmlEncode = new XmlEncode();
            DecompileCallback.encodeInstruction((Encoder)xmlEncode, con.baseAddr, pcode, fallThruOffset, payload.getParamShift(), this.addrfactory);
            this.debug.addInject(con.baseAddr, nm, type, xmlEncode.toString());
        }
    }

    public void getCPoolRef(long[] refs, Encoder resultEncoder) throws IOException {
        if (this.cpool == null) {
            this.cpool = this.pcodecompilerspec.getPcodeInjectLibrary().getConstantPool(this.program);
        }
        ConstantPool.Record record = this.cpool.getRecord(refs);
        record.encode(resultEncoder, refs[0], this.dtmanage);
        if (this.debug != null) {
            XmlEncode xmlEncode = new XmlEncode();
            record.encode((Encoder)xmlEncode, refs[0], this.dtmanage);
            this.debug.getCPoolRef(xmlEncode.toString(), refs);
        }
    }

    private Instruction getInstruction(Address addr) throws UnknownInstructionException {
        Instruction instr = this.listing.getInstructionAt(addr);
        if (instr == null) {
            instr = this.pseudoDisassemble(addr);
        }
        return instr;
    }

    private Instruction pseudoDisassemble(Address addr) throws UnknownInstructionException {
        Instruction instr;
        if (this.lastPseudoInstructionBlock != null) {
            instr = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (instr != null) {
                return instr;
            }
            InstructionError error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            this.lastPseudoInstructionBlock = null;
        }
        if (this.pseudoDisassembler == null) {
            this.pseudoDisassembler = Disassembler.getDisassembler((Program)this.program, (boolean)false, (boolean)false, (boolean)false, (TaskMonitor)TaskMonitor.DUMMY, msg -> {});
        }
        RegisterValue entryContext = null;
        ProgramContext programContext = this.program.getProgramContext();
        Register baseContextRegister = programContext.getBaseContextRegister();
        if (baseContextRegister != null) {
            entryContext = programContext.getRegisterValue(baseContextRegister, this.funcEntry);
        }
        this.lastPseudoInstructionBlock = this.pseudoDisassembler.pseudoDisassembleBlock(addr, entryContext, 64);
        if (this.lastPseudoInstructionBlock != null) {
            InstructionError error = this.lastPseudoInstructionBlock.getInstructionConflict();
            if (error != null && error.getConflictMessage().startsWith("Maximum run of Zero-Byte")) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            instr = this.lastPseudoInstructionBlock.getInstructionAt(addr);
            if (instr != null) {
                return instr;
            }
            if (error != null && addr.equals((Object)error.getInstructionAddress())) {
                throw new UnknownInstructionException(error.getConflictMessage());
            }
            if (this.program.getMemory().isExternalBlockAddress(addr)) {
                throw new UnknownInstructionException("Unable to disassemble EXTERNAL block location: " + String.valueOf(addr));
            }
        }
        throw new UnknownInstructionException("Invalid instruction address (improperly aligned)");
    }

    public String getCodeLabel(Address addr) throws IOException {
        Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
        if (sym == null) {
            return null;
        }
        String res = this.getSymbolName(sym);
        if (this.debug != null) {
            this.debug.getCodeSymbol(addr, sym.getID(), res, sym.getParentNamespace());
        }
        return res;
    }

    private String getSymbolName(Symbol sym) {
        String prefix = this.getNamespacePrefix(sym.getParentNamespace());
        if (prefix != null) {
            return prefix + "_" + sym.getName();
        }
        return sym.getName();
    }

    private Namespace getNameSpaceByID(long id) {
        Symbol namespaceSym = this.program.getSymbolTable().getSymbol(id);
        if (namespaceSym == null) {
            return null;
        }
        Object namespace = namespaceSym.getObject();
        if (namespace instanceof Namespace) {
            return (Namespace)namespace;
        }
        return null;
    }

    private String getNamespacePrefix(Namespace ns) {
        if (ns.getID() == 0L) {
            return null;
        }
        if (ns instanceof Function && ((Function)ns).getEntryPoint().equals((Object)this.funcEntry)) {
            return null;
        }
        String name = ns.getName();
        String parentName = this.getNamespacePrefix(ns.getParentNamespace());
        if (parentName != null) {
            return parentName + "_" + name;
        }
        return name;
    }

    public boolean isNameUsed(String name, long startId, long stopId) {
        Namespace namespace = this.getNameSpaceByID(startId);
        int pathSize = 0;
        Namespace curspace = namespace;
        long curId = namespace.getID();
        while (curId != stopId && curId != 0L && !HighFunction.collapseToGlobal((Namespace)curspace)) {
            ++pathSize;
            curspace = curspace.getParentNamespace();
            curId = curspace.getID();
        }
        long[] path = new long[pathSize];
        curspace = namespace;
        path[0] = startId;
        for (int i = 1; i < pathSize; ++i) {
            curspace = curspace.getParentNamespace();
            path[i] = curspace.getID();
        }
        int count = 0;
        SymbolIterator iter = this.program.getSymbolTable().getSymbols(name);
        while (iter.hasNext() && ++count <= 16) {
            Namespace symSpace = iter.next().getParentNamespace();
            long id = symSpace.getID();
            if (id == 0L) continue;
            for (int i = 0; i < pathSize; ++i) {
                if (path[i] != id) continue;
                if (this.debug != null) {
                    this.debug.nameIsUsed(symSpace, name);
                }
                return true;
            }
        }
        return count > 16;
    }

    public void getNamespacePath(long id, Encoder resultEncoder) throws IOException {
        Namespace namespace = this.getNameSpaceByID(id);
        HighFunction.encodeNamespace((Encoder)resultEncoder, (Namespace)namespace, (NameTransformer)this.dtmanage.getNameTransformer());
        if (this.debug != null) {
            this.debug.getNamespacePath(namespace);
        }
    }

    private void encodeHeaderComment(Encoder encoder, Function func) throws IOException {
        Address addr = func.getEntryPoint();
        String text = this.listing.getComment(CommentType.PLATE, addr);
        if (text != null) {
            encoder.openElement(ElementId.ELEM_COMMENT);
            encoder.writeString(AttributeId.ATTRIB_TYPE, "header");
            AddressXML.encode((Encoder)encoder, (Address)addr);
            AddressXML.encode((Encoder)encoder, (Address)addr);
            encoder.openElement(ElementId.ELEM_TEXT);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, text);
            encoder.closeElement(ElementId.ELEM_TEXT);
            encoder.closeElement(ElementId.ELEM_COMMENT);
        }
    }

    private void encodeCommentsType(Encoder encoder, AddressSetView addrset, Address addr, CommentType commenttype) throws IOException {
        String typename = switch (commenttype) {
            case CommentType.EOL -> "user1";
            case CommentType.PRE -> "user2";
            case CommentType.POST -> "user3";
            case CommentType.PLATE -> "header";
            default -> "";
        };
        AddressIterator iter = this.listing.getCommentAddressIterator(commenttype, addrset, true);
        while (iter.hasNext()) {
            Address commaddr = iter.next();
            String text = this.listing.getComment(commenttype, commaddr);
            if (text == null || commenttype == CommentType.PLATE && commaddr.equals((Object)addr)) continue;
            encoder.openElement(ElementId.ELEM_COMMENT);
            encoder.writeString(AttributeId.ATTRIB_TYPE, typename);
            AddressXML.encode((Encoder)encoder, (Address)addr);
            AddressXML.encode((Encoder)encoder, (Address)commaddr);
            encoder.openElement(ElementId.ELEM_TEXT);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, text);
            encoder.closeElement(ElementId.ELEM_TEXT);
            encoder.closeElement(ElementId.ELEM_COMMENT);
        }
    }

    private void encodeComments(Encoder encoder, Address addr, Function func, int flags) throws IOException {
        AddressSetView addrset = func.getBody();
        encoder.openElement(ElementId.ELEM_COMMENTDB);
        if ((flags & 8) != 0) {
            this.encodeHeaderComment(encoder, func);
        }
        if ((flags & 1) != 0) {
            this.encodeCommentsType(encoder, addrset, addr, CommentType.EOL);
        }
        if ((flags & 2) != 0) {
            this.encodeCommentsType(encoder, addrset, addr, CommentType.PRE);
        }
        if ((flags & 4) != 0) {
            this.encodeCommentsType(encoder, addrset, addr, CommentType.POST);
        }
        if ((flags & 8) != 0) {
            this.encodeCommentsType(encoder, addrset, addr, CommentType.PLATE);
        }
        encoder.closeElement(ElementId.ELEM_COMMENTDB);
    }

    public void getMappedSymbols(Address addr, Encoder resultEncoder) throws IOException {
        if (addr == Address.NO_ADDRESS) {
            return;
        }
        Object obj = this.lookupSymbol(addr);
        if (obj instanceof Function) {
            boolean includeDefaults = addr.equals((Object)this.funcEntry);
            this.encodeFunction(resultEncoder, (Function)obj, addr, includeDefaults);
        } else if (obj instanceof Data) {
            if (!this.encodeData(resultEncoder, (Data)obj)) {
                this.encodeHole(resultEncoder, addr);
            }
        } else if (obj instanceof ExternalReference) {
            this.encodeExternalRef(resultEncoder, addr, (ExternalReference)obj);
        } else if (obj instanceof Symbol) {
            this.encodeLabel(resultEncoder, (Symbol)obj, addr);
        } else {
            this.encodeHole(resultEncoder, addr);
        }
    }

    public void getExternalRef(Address addr, Encoder resultEncoder) throws IOException {
        int extrapop;
        Function func = null;
        if (this.cachedFunction != null && this.cachedFunction.getEntryPoint().equals((Object)addr)) {
            func = this.cachedFunction;
        } else {
            ExternalReference extRef = this.getExternalReference(addr);
            if (extRef != null) {
                func = this.listing.getFunctionAt(extRef.getToAddress());
                if (func == null) {
                    Symbol symbol = extRef.getExternalLocation().getSymbol();
                    long extId = symbol != null ? symbol.getID() : this.program.getSymbolTable().getDynamicSymbolID(addr);
                    HighFunctionShellSymbol shellSymbol = new HighFunctionShellSymbol(extId, extRef.getLabel(), addr, this.dtmanage);
                    this.encodeResult(resultEncoder, (HighSymbol)shellSymbol, null);
                    return;
                }
            } else {
                func = this.listing.getFunctionAt(addr);
            }
        }
        if (func == null) {
            return;
        }
        HighFunction hfunc = new HighFunction(func, this.pcodelanguage, this.pcodecompilerspec, this.dtmanage);
        hfunc.grabFromFunction(extrapop, false, (extrapop = this.getExtraPopOverride(func, addr)) != this.default_extrapop);
        HighFunctionSymbol funcSymbol = new HighFunctionSymbol(addr, 2, hfunc);
        Namespace namespc = funcSymbol.getNamespace();
        if (this.debug != null) {
            this.debug.getFNTypes(hfunc);
            this.debug.addPossiblePrototypeExtension(func);
        }
        this.encodeResult(resultEncoder, (HighSymbol)funcSymbol, namespc);
    }

    public void getDataType(String name, long id, Encoder resultEncoder) throws IOException {
        DataType type = this.dtmanage.findBaseType(name, id);
        if (type == null) {
            return;
        }
        this.dtmanage.encodeType(resultEncoder, type, 0);
        if (this.debug != null) {
            this.debug.getType(type);
        }
    }

    public void getRegister(String name, Encoder resultEncoder) throws IOException {
        Register reg = this.pcodelanguage.getRegister(name);
        if (reg == null) {
            throw new RuntimeException("No Register Defined: " + name);
        }
        DecompileCallback.encodeRegister(resultEncoder, reg);
    }

    public String getRegisterName(Address addr, int size) {
        Register reg = this.pcodelanguage.getRegister(addr, size);
        if (reg == null) {
            return "";
        }
        return reg.getName();
    }

    public void getTrackedRegisters(Address addr, Encoder resultEncoder) throws IOException {
        ProgramContext context = this.program.getProgramContext();
        this.encodeTrackedPointSet(resultEncoder, addr, context);
        if (this.debug != null) {
            XmlEncode xmlEncode = new XmlEncode();
            this.encodeTrackedPointSet((Encoder)xmlEncode, addr, context);
            this.debug.getTrackedRegisters(xmlEncode.toString());
        }
    }

    public String getUserOpName(int index) {
        String name = this.pcodelanguage.getUserDefinedOpName(index);
        return name;
    }

    private void encodeResult(Encoder encoder, HighSymbol highSymbol, Namespace namespc) throws IOException {
        long namespaceId = namespc == null || namespc instanceof Library ? 0L : namespc.getID();
        encoder.openElement(ElementId.ELEM_DOC);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, namespaceId);
        if (this.debug != null) {
            XmlEncode debugEncode = new XmlEncode();
            HighSymbol.encodeMapSym((Encoder)debugEncode, (HighSymbol)highSymbol);
            String res2string = debugEncode.toString();
            this.debug.getMapped(namespc, res2string);
        }
        HighSymbol.encodeMapSym((Encoder)encoder, (HighSymbol)highSymbol);
        encoder.closeElement(ElementId.ELEM_DOC);
    }

    private boolean encodeData(Encoder encoder, Data data) throws IOException {
        HighCodeSymbol highSymbol;
        Symbol sym = data.getPrimarySymbol();
        if (sym != null) {
            highSymbol = new HighCodeSymbol(sym.getID(), sym.getName(), data, this.dtmanage);
        } else {
            highSymbol = new HighCodeSymbol(0L, SymbolUtilities.getDynamicName((Program)this.program, (Address)data.getAddress()), data, this.dtmanage);
            if (data.getDataType() == DataType.DEFAULT && highSymbol.getMutability() == 0) {
                return false;
            }
        }
        if (this.debug != null) {
            this.debug.getType(highSymbol.getDataType());
        }
        Namespace namespc = sym != null ? sym.getParentNamespace() : null;
        this.encodeResult(encoder, (HighSymbol)highSymbol, namespc);
        return true;
    }

    private static void encodeRegister(Encoder encoder, Register reg) throws IOException {
        encoder.openElement(ElementId.ELEM_ADDR);
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, reg.getAddressSpace());
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, (long)reg.getOffset());
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, (long)reg.getMinimumByteSize());
        encoder.closeElement(ElementId.ELEM_ADDR);
    }

    private void encodeLabel(Encoder encoder, Symbol sym, Address addr) throws IOException {
        HighLabelSymbol labelSymbol = new HighLabelSymbol(sym.getName(), addr, this.dtmanage);
        Namespace namespc = sym.getParentNamespace();
        this.encodeResult(encoder, (HighSymbol)labelSymbol, namespc);
    }

    private void encodeFunction(Encoder encoder, Function func, Address addr, boolean includeDefaultNames) throws IOException {
        long diff;
        Address entry = func.getEntryPoint();
        if (entry.getAddressSpace().equals((Object)addr.getAddressSpace()) && (diff = addr.getOffset() - entry.getOffset()) >= 0L && diff < 8L) {
            int extrapop;
            HighFunction hfunc = new HighFunction(func, this.pcodelanguage, this.pcodecompilerspec, this.dtmanage);
            hfunc.grabFromFunction(extrapop, includeDefaultNames, (extrapop = this.getExtraPopOverride(func, addr)) != this.default_extrapop);
            HighFunctionSymbol functionSymbol = new HighFunctionSymbol(entry, (int)(diff + 1L), hfunc);
            Namespace namespc = functionSymbol.getNamespace();
            if (this.debug != null) {
                this.debug.getFNTypes(hfunc);
                this.debug.addPossiblePrototypeExtension(func);
            }
            this.encodeResult(encoder, (HighSymbol)functionSymbol, namespc);
            return;
        }
        AddressRangeIterator iter = func.getBody().getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            if (!range.contains(addr)) continue;
            Address first = range.getMinAddress();
            Address last = range.getMaxAddress();
            this.encodeHole(encoder, first.getAddressSpace(), first.getUnsignedOffset(), last.getUnsignedOffset(), 2);
            return;
        }
        this.encodeHole(encoder, addr.getAddressSpace(), addr.getUnsignedOffset(), addr.getUnsignedOffset(), 2);
    }

    private int getExtraPopOverride(Function func, Address addr) {
        if (func.getEntryPoint().equals((Object)this.funcEntry)) {
            return this.default_extrapop;
        }
        int extrapop = this.default_extrapop;
        Function containedFunc = this.getFunctionAt(this.funcEntry);
        if (containedFunc == null) {
            return extrapop;
        }
        AddressIterator iter = CallDepthChangeInfo.getStackDepthChanges((Program)containedFunc.getProgram(), (AddressSetView)containedFunc.getBody());
        while (iter.hasNext()) {
            Reference[] refs;
            Address changeAddr = iter.next();
            for (Reference element : refs = func.getProgram().getReferenceManager().getFlowReferencesFrom(changeAddr)) {
                Integer change;
                if (!element.getToAddress().equals((Object)addr) || (change = CallDepthChangeInfo.getStackDepthChange((Program)func.getProgram(), (Address)changeAddr)) == null) continue;
                extrapop = change;
            }
        }
        return extrapop;
    }

    private void encodeHole(Encoder encoder, AddressSpace spc, long first, long last, int mutability) throws IOException {
        encoder.openElement(ElementId.ELEM_HOLE);
        if (mutability == 2) {
            encoder.writeBool(AttributeId.ATTRIB_READONLY, true);
        } else if (mutability == 1) {
            encoder.writeBool(AttributeId.ATTRIB_VOLATILE, true);
        }
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, spc);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, first);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, last);
        encoder.closeElement(ElementId.ELEM_HOLE);
    }

    private void encodeHole(Encoder encoder, Address addr) throws IOException {
        int mutability = MappedEntry.getMutabilityOfAddress((Address)addr, (Program)this.program);
        this.encodeHole(encoder, addr.getAddressSpace(), addr.getUnsignedOffset(), addr.getUnsignedOffset(), mutability);
    }

    private void encodeExternalRef(Encoder encoder, Address addr, ExternalReference ref) throws IOException {
        HighExternalSymbol externSymbol = new HighExternalSymbol(ref.getLabel(), addr, addr, this.dtmanage);
        this.encodeResult(encoder, (HighSymbol)externSymbol, null);
    }

    private void encodeTrackSet(Encoder encoder, Register reg, long val) throws IOException {
        AddressSpace spc = reg.getAddressSpace();
        long offset = reg.getOffset();
        int size = reg.getMinimumByteSize();
        encoder.openElement(ElementId.ELEM_SET);
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, spc);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, offset);
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, (long)size);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_VAL, val);
        encoder.closeElement(ElementId.ELEM_SET);
    }

    private void encodeTrackedPointSet(Encoder encoder, Address addr, ProgramContext context) throws IOException {
        encoder.openElement(ElementId.ELEM_TRACKED_POINTSET);
        AddressXML.encodeAttributes((Encoder)encoder, (Address)addr);
        for (Register reg : context.getRegisters()) {
            BigInteger val;
            if (reg.isProcessorContext() || (val = context.getValue(reg, addr, false)) == null) continue;
            this.encodeTrackSet(encoder, reg, val.longValue());
        }
        encoder.closeElement(ElementId.ELEM_TRACKED_POINTSET);
    }

    private ExternalReference getExternalReference(Address addr) {
        Reference ref;
        Data data = this.listing.getDefinedDataAt(addr);
        if (data != null && data.isPointer() && (ref = data.getPrimaryReference(0)) instanceof ExternalReference) {
            return (ExternalReference)ref;
        }
        return null;
    }

    private Object lookupSymbol(Address addr) {
        ExternalReference ref = this.getExternalReference(addr);
        if (ref != null) {
            return ref;
        }
        Function func = this.getFunctionContaining(addr);
        if (func != null) {
            return func;
        }
        Register reg = this.program.getRegister(addr);
        if (reg != null) {
            return null;
        }
        Data data = this.listing.getDataContaining(addr);
        if (data != null) {
            return data;
        }
        Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
        if (sym != null && sym.isGlobal()) {
            return sym;
        }
        return null;
    }

    private Function getFunctionContaining(Address addr) {
        if (this.cachedFunction != null && this.cachedFunction.getBody().contains(addr)) {
            return this.cachedFunction;
        }
        return this.listing.getFunctionContaining(addr);
    }

    private Function getFunctionAt(Address addr) {
        if (this.cachedFunction != null && this.cachedFunction.getEntryPoint().equals((Object)addr)) {
            return this.cachedFunction;
        }
        ExternalReference extRef = this.getExternalReference(addr);
        if (extRef != null) {
            return this.listing.getFunctionAt(extRef.getToAddress());
        }
        return this.listing.getFunctionAt(addr);
    }

    private boolean isValidChars(String string) {
        char replaceChar = '\ufffd';
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != replaceChar) continue;
            return false;
        }
        return true;
    }

    public StringData getStringData(Address addr, int maxChars, String dtName, long dtId) {
        if (addr == Address.NO_ADDRESS) {
            Msg.error((Object)this, (Object)"Address does not physically map");
            return null;
        }
        Data data = this.program.getListing().getDataContaining(addr);
        StringDataInstance stringInstance = StringDataInstance.getStringDataInstance((Data)data);
        if (stringInstance != StringDataInstance.NULL_INSTANCE) {
            long diff = addr.subtract(data.getAddress()) * (long)addr.getAddressSpace().getAddressableUnitSize();
            int length = data.getLength();
            if (length <= 0 || diff < 0L || diff >= (long)length) {
                return null;
            }
            stringInstance = stringInstance.getByteOffcut((int)diff);
        } else {
            MemoryBufferImpl buf;
            AbstractStringDataType dt = this.coerceToStringDataType(this.dtmanage.findBaseType(dtName, dtId));
            stringInstance = dt.getStringDataInstance((MemBuffer)(buf = new MemoryBufferImpl(this.program.getMemory(), addr, 64)), SettingsImpl.NO_SETTINGS, maxChars);
            int length = stringInstance.getStringLength();
            if (length < 0 || length > maxChars) {
                return null;
            }
        }
        String stringVal = stringInstance.isShowTranslation() && stringInstance.getTranslatedValue() != null ? stringInstance.getTranslatedValue() : stringInstance.getStringValue();
        if (!this.isValidChars(stringVal)) {
            return null;
        }
        StringData stringData = new StringData(stringVal, maxChars);
        if (this.debug != null) {
            this.debug.getStringData(addr, stringData);
        }
        return stringData;
    }

    private AbstractStringDataType coerceToStringDataType(DataType dt) {
        if (dt instanceof AbstractStringDataType) {
            AbstractStringDataType asdt = (AbstractStringDataType)dt;
            return asdt;
        }
        int size = -1;
        if (dt != null) {
            if (dt instanceof Array) {
                Array arrayDT = (Array)dt;
                dt = arrayDT.getDataType();
            }
            size = dt.getLength();
        }
        return switch (size) {
            default -> TerminatedStringDataType.dataType;
            case 2 -> TerminatedUnicodeDataType.dataType;
            case 4 -> TerminatedUnicode32DataType.dataType;
        };
    }

    public static class StringData {
        boolean isTruncated = false;
        public byte[] byteData;

        public StringData(String stringVal, int maxChars) {
            if (stringVal.length() > maxChars) {
                this.isTruncated = true;
                stringVal = stringVal.substring(0, maxChars);
            }
            this.byteData = stringVal.getBytes(StandardCharsets.UTF_8);
        }
    }
}

