/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.arm;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.math.BigInteger;

@DisassemblyInjectInfo(platforms={@DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v8"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v8T"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LEBE:32:v8LEInstruction"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v8"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v8T"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v7"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LEBE:32:v7LEInstruction"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v7"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:Cortex"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:Cortex"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v6"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v6"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v5t"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v5t"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v5"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v5"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v4t"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v4t"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:LE:32:v4"), @DisassemblyInjectInfo.PlatformInfo(langID="ARM:BE:32:v4")})
public class ArmDisassemblyInject
implements DisassemblyInject {
    protected static final long THUMB_BIT = 32L;

    protected boolean isThumbMode(RegisterValue cpsr) {
        return (cpsr.getUnsignedValue().longValue() & 0x20L) != 0L;
    }

    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, TracePlatform platform, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        Language language = platform.getLanguage();
        Register cpsrReg = language.getRegister("cpsr");
        Register tModeReg = language.getRegister("TMode");
        if (cpsrReg == null || tModeReg == null) {
            Msg.error((Object)this, (Object)("No cpsr or TMode register in ARM language?: " + String.valueOf(language.getLanguageID())));
            return;
        }
        TraceMemorySpace regs = platform.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, false);
        if (regs == null || regs.getState(platform, snap, cpsrReg) != TraceMemoryState.KNOWN) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
            return;
        }
        RegisterValue cpsrVal = regs.getValue(platform, snap, cpsrReg);
        if (this.isThumbMode(cpsrVal)) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
        } else {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ZERO));
        }
    }
}

