/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.InvalidInputException;

public class SetExternalNameCmd
implements Command<Program> {
    private String externalName;
    private String externalPath;
    private String status;
    private boolean userDefined = true;

    public SetExternalNameCmd(String externalName, String externalPath) {
        this.externalName = externalName;
        this.externalPath = externalPath;
    }

    public boolean applyTo(Program program) {
        try {
            program.getExternalManager().setExternalPath(this.externalName, this.externalPath, this.userDefined);
        }
        catch (InvalidInputException e) {
            this.status = "Invalid name specified";
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Set External Program Name";
    }
}

