/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import docking.widgets.MultiLineLabel;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GIconLabel;
import ghidra.app.merge.datatypes.DataTypePanel;
import ghidra.app.merge.util.ConflictCountPanel;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import resources.Icons;

class DataTypeMergePanel
extends JPanel {
    public static final String LATEST_BUTTON_NAME = "Latest";
    public static final String CHECKED_OUT_BUTTON_NAME = "Checked Out";
    public static final String ORIGINAL_BUTTON_NAME = "Original";
    private DomainObjectMergeManager mergeManager;
    private int totalConflicts;
    private ConflictCountPanel countPanel;
    private DataTypePanel latestPanel;
    private DataTypePanel myPanel;
    private DataTypePanel origPanel;
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private ButtonGroup buttonGroup;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;

    DataTypeMergePanel(DomainObjectMergeManager mergeManager, int totalConflicts) {
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(int conflictIndex, DataType latestDt, DataType myDt, DataType origDt) {
        this.mergeManager.setApplyEnabled(false);
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
        this.latestPanel.setDataType(latestDt);
        this.myPanel.setDataType(myDt);
        this.origPanel.setDataType(origDt);
        this.buttonGroup.remove(this.latestRB);
        this.buttonGroup.remove(this.myRB);
        this.buttonGroup.remove(this.originalRB);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.buttonGroup.add(this.latestRB);
        this.buttonGroup.add(this.myRB);
        this.buttonGroup.add(this.originalRB);
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 0;
        }
        if (this.myRB.isSelected()) {
            return 1;
        }
        if (this.originalRB.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void create() {
        this.buttonGroup = new ButtonGroup();
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.mergeManager.clearStatusText();
                this.mergeManager.setApplyEnabled(true);
            }
        };
        this.latestRB = new GRadioButton(LATEST_BUTTON_NAME);
        this.latestRB.setName(LATEST_BUTTON_NAME);
        this.latestRB.addItemListener(listener);
        this.myRB = new GRadioButton(CHECKED_OUT_BUTTON_NAME);
        this.myRB.setName(CHECKED_OUT_BUTTON_NAME);
        this.myRB.addItemListener(listener);
        this.originalRB = new GRadioButton(ORIGINAL_BUTTON_NAME);
        this.originalRB.setName(ORIGINAL_BUTTON_NAME);
        this.originalRB.addItemListener(listener);
        this.buttonGroup.add(this.latestRB);
        this.buttonGroup.add(this.myRB);
        this.buttonGroup.add(this.originalRB);
        this.setLayout(new BoxLayout(this, 1));
        this.countPanel = new ConflictCountPanel();
        JPanel dtPanel = new JPanel();
        dtPanel.setLayout(new BoxLayout(dtPanel, 0));
        dtPanel.add(this.createDataTypePanel(this.latestRB));
        dtPanel.add(this.createDataTypePanel(this.myRB));
        dtPanel.add(this.createDataTypePanel(this.originalRB));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        innerPanel.add(this.createInfoPanel());
        innerPanel.add(dtPanel);
        innerPanel.add(Box.createVerticalStrut(10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.countPanel, "North");
        this.add((Component)innerPanel, "Center");
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    private JPanel createDataTypePanel(JRadioButton rb) {
        JPanel panel = new JPanel(new BorderLayout());
        StructureDataType s = new StructureDataType("Test", 0);
        s.add((DataType)new ByteDataType());
        s.add((DataType)new WordDataType());
        s.add((DataType)new QWordDataType());
        DataTypePanel dtPanel = new DataTypePanel((DataType)s);
        JScrollPane sp = new JScrollPane(dtPanel);
        sp.getViewport().setPreferredSize(new Dimension(300, 400));
        panel.add(sp);
        panel.add((Component)rb, "South");
        if (rb == this.latestRB) {
            this.latestPanel = dtPanel;
        } else if (rb == this.myRB) {
            this.myPanel = dtPanel;
        } else {
            this.origPanel = dtPanel;
        }
        return panel;
    }

    private JPanel createInfoPanel() {
        Icon icon = Icons.INFO_ICON;
        GIconLabel imageLabel = new GIconLabel(icon);
        MultiLineLabel label = new MultiLineLabel("A data type change in your checked out version conflicts with a data type change in the latest version.\nSelect the data type change you want included in the version that will result from this check-in.");
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)imageLabel);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add((Component)label);
        return labelPanel;
    }

    private JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new GCheckBox(this.getUseAllString("Data Type"));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    private String getUseAllString(String conflictType) {
        return "Use the selected option for resolving all remaining '" + conflictType + "' conflicts.";
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

