/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DuplicateAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.duplicate");
    public static final String ACTION_NAME = "Duplicate Component";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Duplicate the selected component";
    private static final String[] POPUP_PATH = new String[]{"Duplicate Component"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(68, 512);

    public DuplicateAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        int[] indices = this.model.getSelectedComponentRows();
        if (indices.length != 1) {
            return;
        }
        int max = this.model.getMaxDuplicates(indices[0]);
        if (max != 0) {
            try {
                this.model.duplicateMultiple(indices[0], 1, TaskMonitor.DUMMY);
            }
            catch (UsrException e1) {
                this.model.setStatus(e1.getMessage(), true);
            }
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isDuplicateAllowed();
    }
}

