/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class DtBackgroundIcon
implements Icon {
    private static Color VERSION_ICON_COLOR = new GColor("color.bg.icon.versioned");
    private static Color ALPHA = GThemeDefaults.Colors.Palette.NO_COLOR;
    private Color bgColor = GThemeDefaults.Colors.Palette.NO_COLOR;
    private int width = 24;
    private int height = 16;

    DtBackgroundIcon() {
        this(false);
    }

    DtBackgroundIcon(boolean isVersioned) {
        this.bgColor = isVersioned ? VERSION_ICON_COLOR : ALPHA;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.bgColor);
        g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
        g.drawLine(x + 1, y, x + this.width - 2, y);
        g.drawLine(x + this.width - 1, y + 1, x + this.width - 1, y + this.height - 2);
        g.drawLine(x + 1, y + this.height - 1, x + this.width - 2, y + this.height - 1);
        g.drawLine(x, y + 1, x, y + this.height - 2);
    }
}

