/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.datastruct.SortedRangeList;
import java.util.Objects;

public class FieldMatcher {
    private String fieldName;
    private SortedRangeList fieldOffsets = new SortedRangeList();
    private DataType dataType;

    public FieldMatcher(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }

    public FieldMatcher(DataType dataType, String fieldName) {
        this.dataType = Objects.requireNonNull(dataType);
        this.fieldName = fieldName;
    }

    public FieldMatcher(DataType dataType, int offset) {
        this.dataType = Objects.requireNonNull(dataType);
        this.fieldOffsets.addRange(offset, offset);
    }

    public boolean isIgnored() {
        return this.fieldName == null && this.fieldOffsets.isEmpty();
    }

    public boolean matches(String dtFieldName, int dtOffset) {
        if (this.isIgnored()) {
            return true;
        }
        if (this.fieldName != null && Objects.equals(this.fieldName, dtFieldName)) {
            return true;
        }
        return this.fieldOffsets.contains(dtOffset);
    }

    public String getDisplayText() {
        if (this.fieldName != null) {
            return this.dataType.getName() + "." + this.fieldName;
        }
        if (!this.fieldOffsets.isEmpty()) {
            String compositeFieldName = this.generateCompositeFieldNameByOffset();
            if (compositeFieldName != null) {
                return compositeFieldName;
            }
            return this.dataType.getName() + " at " + this.fieldOffsets.toString();
        }
        return this.dataType.getName();
    }

    private String generateCompositeFieldNameByOffset() {
        long n = this.fieldOffsets.getNumValues();
        if (n != 1L) {
            return null;
        }
        int offset = this.fieldOffsets.getMin();
        if (this.dataType instanceof Structure) {
            Structure structure = (Structure)this.dataType;
            DataTypeComponent dtc = structure.getComponentContaining(offset);
            if (dtc != null) {
                String name = dtc.getFieldName();
                if (name != null) {
                    return name;
                }
                return dtc.getDefaultFieldName();
            }
        } else if (this.dataType instanceof Composite) {
            DataTypeComponent[] components;
            Composite composite = (Composite)this.dataType;
            for (DataTypeComponent dtc : components = composite.getComponents()) {
                int dtcOffset = dtc.getOffset();
                if (dtcOffset != offset) continue;
                return dtc.getFieldName();
            }
        }
        return null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getFieldName() {
        if (this.fieldName != null) {
            return this.fieldName;
        }
        return this.generateCompositeFieldNameByOffset();
    }

    public String toString() {
        return this.getDisplayText();
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.fieldName, this.fieldOffsets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMatcher other = (FieldMatcher)obj;
        if (!Objects.equals(this.dataType, other.dataType)) {
            return false;
        }
        if (!Objects.equals(this.fieldName, other.fieldName)) {
            return false;
        }
        return Objects.equals(this.fieldOffsets, other.fieldOffsets);
    }
}

