/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.util.bin.format.dwarf.external.BuildIdSearchLocation;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugFilesService;
import ghidra.app.util.bin.format.dwarf.external.LocalDirectorySearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SameDirSearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationRegistry;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="DWARF External Debug Files", description="Configure how the DWARF analyzer finds external debug files.")
public class DWARFExternalDebugFilesPlugin
extends Plugin {
    private static final String EXT_DEBUG_FILES_OPTION = "ExternalDebugFiles";
    private static final String SEARCH_LOCATIONS_LIST_OPTION = "ExternalDebugFiles.searchLocations";

    public DWARFExternalDebugFilesPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("DWARF External Debug Config", this.getName()).menuPath(new String[]{"&Edit", "DWARF External Debug Config"})).menuGroup("AOptions")).onAction(ac -> this.showConfigDialog())).buildAndInstall((Tool)this.tool);
    }

    private void showConfigDialog() {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText("Select");
        chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        chooser.setTitle("Select External Debug Files Directory");
        File selectedDir = chooser.getSelectedFile();
        chooser.dispose();
        if (selectedDir == null) {
            return;
        }
        BuildIdSearchLocation bisl = new BuildIdSearchLocation(new File(selectedDir, ".build-id"));
        LocalDirectorySearchLocation ldsl = new LocalDirectorySearchLocation(selectedDir);
        SameDirSearchLocation sdsl = new SameDirSearchLocation(new File("does not matter"));
        ExternalDebugFilesService edfs = new ExternalDebugFilesService(List.of(bisl, ldsl, sdsl));
        DWARFExternalDebugFilesPlugin.saveExternalDebugFilesService(edfs);
    }

    public static ExternalDebugFilesService getExternalDebugFilesService(SearchLocationCreatorContext context) {
        SearchLocationRegistry searchLocRegistry = SearchLocationRegistry.getInstance();
        String searchPathStr = Preferences.getProperty((String)SEARCH_LOCATIONS_LIST_OPTION, (String)"", (boolean)true);
        String[] pathParts = searchPathStr.split(";");
        ArrayList<SearchLocation> searchLocs = new ArrayList<SearchLocation>();
        for (String part : pathParts) {
            SearchLocation searchLoc;
            if (part.isBlank() || (searchLoc = searchLocRegistry.createSearchLocation(part, context)) == null) continue;
            searchLocs.add(searchLoc);
        }
        if (searchLocs.isEmpty()) {
            searchLocs.add(SameDirSearchLocation.create(null, context));
        }
        return new ExternalDebugFilesService(searchLocs);
    }

    public static void saveExternalDebugFilesService(ExternalDebugFilesService service) {
        if (service != null) {
            String path = service.getSearchLocations().stream().map(SearchLocation::getName).collect(Collectors.joining(";"));
            Preferences.setProperty((String)SEARCH_LOCATIONS_LIST_OPTION, (String)path);
        } else {
            Preferences.setProperty((String)SEARCH_LOCATIONS_LIST_OPTION, null);
        }
    }
}

