/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheMappingAndSlideInfo
implements StructConverter {
    public static long DYLD_CACHE_MAPPING_AUTH_DATA = 1L;
    public static long DYLD_CACHE_MAPPING_DIRTY_DATA = 2L;
    public static long DYLD_CACHE_MAPPING_CONST_DATA = 4L;
    public static long DYLD_CACHE_MAPPING_TEXT_STUBS = 8L;
    public static long DYLD_CACHE_DYNAMIC_CONFIG_DATA = 16L;
    public static long DYLD_CACHE_READ_ONLY_DATA = 32L;
    public static long DYLD_CACHE_MAPPING_CONST_TPRO_DATA = 64L;
    private long address;
    private long size;
    private long fileOffset;
    private long slideInfoFileOffset;
    private long slideInfoFileSize;
    private long flags;
    private int maxProt;
    private int initProt;

    public DyldCacheMappingAndSlideInfo(BinaryReader reader) throws IOException {
        this.address = reader.readNextLong();
        this.size = reader.readNextLong();
        this.fileOffset = reader.readNextLong();
        this.slideInfoFileOffset = reader.readNextLong();
        this.slideInfoFileSize = reader.readNextLong();
        this.flags = reader.readNextLong();
        this.maxProt = reader.readNextInt();
        this.initProt = reader.readNextInt();
    }

    public long getAddress() {
        return this.address;
    }

    public long getSize() {
        return this.size;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getSlideInfoFileOffset() {
        return this.slideInfoFileOffset;
    }

    public long getSlideInfoFileSize() {
        return this.slideInfoFileSize;
    }

    public long getFlags() {
        return this.flags;
    }

    public int getMaxProtection() {
        return this.maxProt;
    }

    public int getInitialProtection() {
        return this.initProt;
    }

    public boolean isAuthData() {
        return (this.flags & DYLD_CACHE_MAPPING_AUTH_DATA) != 0L;
    }

    public boolean isDirtyData() {
        return (this.flags & DYLD_CACHE_MAPPING_DIRTY_DATA) != 0L;
    }

    public boolean isConstData() {
        return (this.flags & DYLD_CACHE_MAPPING_CONST_DATA) != 0L;
    }

    public boolean isTextStubs() {
        return (this.flags & DYLD_CACHE_MAPPING_TEXT_STUBS) != 0L;
    }

    public boolean isConfigData() {
        return (this.flags & DYLD_CACHE_DYNAMIC_CONFIG_DATA) != 0L;
    }

    public boolean isReadOnlyData() {
        return (this.flags & DYLD_CACHE_READ_ONLY_DATA) != 0L;
    }

    public boolean isConstTproData() {
        return (this.flags & DYLD_CACHE_MAPPING_CONST_TPRO_DATA) != 0L;
    }

    public boolean isRead() {
        return (this.initProt & 1) != 0;
    }

    public boolean isWrite() {
        return (this.initProt & 2) != 0;
    }

    public boolean isExecute() {
        return (this.initProt & 4) != 0;
    }

    public boolean contains(long addr, boolean isAddr) {
        return isAddr ? Long.compareUnsigned(addr, this.address) >= 0 && Long.compareUnsigned(addr, this.address + this.size) < 0 : Long.compareUnsigned(addr, this.fileOffset) >= 0 && Long.compareUnsigned(addr, this.fileOffset + this.size) < 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_mapping_and_slide_info", 0);
        struct.add(QWORD, "address", "");
        struct.add(QWORD, "size", "");
        struct.add(QWORD, "fileOffset", "");
        struct.add(QWORD, "slideInfoFileOffset", "");
        struct.add(QWORD, "slideInfoFileSize", "");
        struct.add(QWORD, "flags", "");
        struct.add(DWORD, "maxProt", "");
        struct.add(DWORD, "initProt", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

