/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.unixaout.UnixAoutHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.UnixAoutProgramLoader;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnixAoutLoader
extends AbstractProgramWrapperLoader {
    public static final String UNIX_AOUT_NAME = "UNIX A.out";
    public static final String OPTION_NAME_BASE_ADDR = "Base Address";

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        String comp;
        String lang;
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        UnixAoutHeader hdrBE = new UnixAoutHeader(provider, false);
        UnixAoutHeader hdrLE = new UnixAoutHeader(provider, true);
        boolean beValid = false;
        if (hdrBE.isValid()) {
            lang = hdrBE.getLanguageSpec();
            comp = hdrBE.getCompilerSpec();
            loadSpecs.add(new LoadSpec(this, 0L, new LanguageCompilerSpecPair(lang, comp), true));
            beValid = true;
        }
        if (hdrLE.isValid()) {
            lang = hdrLE.getLanguageSpec();
            comp = hdrLE.getCompilerSpec();
            loadSpecs.add(new LoadSpec(this, 0L, new LanguageCompilerSpecPair(lang, comp), !beValid));
        }
        return loadSpecs;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws CancelledException, IOException {
        boolean isLittleEndian = !program.getLanguage().isBigEndian();
        UnixAoutHeader header = new UnixAoutHeader(provider, isLittleEndian);
        UnixAoutProgramLoader loader = new UnixAoutProgramLoader(program, header, monitor, log);
        loader.loadAout(this.getBaseAddrOffset(options));
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        Address baseAddr = null;
        for (Option option : options) {
            String optName = option.getName();
            try {
                if (!optName.equals(OPTION_NAME_BASE_ADDR)) continue;
                baseAddr = (Address)option.getValue();
            }
            catch (Exception e) {
                if (e instanceof OptionException) {
                    return e.getMessage();
                }
                return "Invalid value for " + optName + " - " + String.valueOf(option.getValue());
            }
        }
        if (baseAddr == null) {
            return "Invalid base address";
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        AddressSpace defaultAddressSpace;
        Program program;
        AddressFactory addressFactory;
        Address baseAddr = null;
        if (domainObject instanceof Program && (addressFactory = (program = (Program)domainObject).getAddressFactory()) != null && (defaultAddressSpace = addressFactory.getDefaultAddressSpace()) != null) {
            baseAddr = defaultAddressSpace.getAddress(0L);
        }
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(OPTION_NAME_BASE_ADDR, baseAddr, Address.class, "-loader-baseAddr"));
        list.addAll(super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram));
        return list;
    }

    @Override
    public String getName() {
        return UNIX_AOUT_NAME;
    }

    private long getBaseAddrOffset(List<Option> options) {
        Address baseAddr = null;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(OPTION_NAME_BASE_ADDR)) continue;
                baseAddr = (Address)option.getValue();
            }
        }
        long offset = 0L;
        if (baseAddr != null) {
            offset = baseAddr.getOffset();
        }
        return offset;
    }
}

