/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.ExportsLegAccessGen;
import ghidra.pcode.emu.jit.gen.type.MethodAccessGen;
import ghidra.program.model.address.AddressSpace;
import org.objectweb.asm.MethodVisitor;

public enum IntWriteGen implements MethodAccessGen,
ExportsLegAccessGen
{
    BE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "writeInt1";
                case 2 -> "writeIntBE2";
                case 3 -> "writeIntBE3";
                case 4 -> "writeIntBE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateMpCodeLeg(JitCodeGenerator gen, AddressSpace space, long block, int off, int size, MethodVisitor rv) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            rv.visitInsn(89);
            rv.visitLdcInsn((Object)(off + size - 4096));
            rv.visitInsn(124);
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
        }
    }
    ,
    LE{

        @Override
        public String chooseName(int size) {
            return switch (size) {
                case 1 -> "writeInt1";
                case 2 -> "writeIntLE2";
                case 3 -> "writeIntLE3";
                case 4 -> "writeIntLE4";
                default -> throw new AssertionError();
            };
        }

        @Override
        public void generateMpCodeLeg(JitCodeGenerator gen, AddressSpace space, long block, int off, int size, MethodVisitor rv) {
            FieldForArrDirect blkField = gen.requestFieldForArrDirect(space.getAddress(block));
            if (off + size <= 4096) {
                blkField.generateLoadCode(gen, rv);
                rv.visitLdcInsn((Object)off);
                rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(size), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
                return;
            }
            FieldForArrDirect nxtField = gen.requestFieldForArrDirect(space.getAddress(block + 4096L));
            rv.visitInsn(89);
            rv.visitLdcInsn((Object)(4096 - off));
            rv.visitInsn(124);
            nxtField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)0);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(off + size - 4096), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
            blkField.generateLoadCode(gen, rv);
            rv.visitLdcInsn((Object)off);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.chooseName(4096 - off), GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_INTX, true);
        }
    };

}

