/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.label;

import docking.widgets.GComponent;
import ghidra.util.Msg;
import ghidra.util.WebColors;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public abstract class AbstractHtmlLabel
extends JLabel
implements GComponent,
PropertyChangeListener {
    private static final String HTML_TAG = "<html>";
    private boolean isUpdating;
    private boolean isHtml;

    protected AbstractHtmlLabel() {
        this.addPropertyChangeListener(this);
    }

    protected AbstractHtmlLabel(String text) {
        super(text);
        this.addPropertyChangeListener(this);
    }

    @Override
    public void setText(String text) {
        if (text != null && text.toLowerCase().startsWith(HTML_TAG)) {
            text = text.substring(HTML_TAG.length());
            this.isHtml = true;
        } else {
            this.isHtml = false;
        }
        super.setText(text);
        this.updateHtmlView();
    }

    public String getOriginalText() {
        return this.isHtml ? HTML_TAG + this.getText() : this.getText();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateHtmlView();
    }

    private void updateHtmlView() {
        String text = this.getText();
        if (text == null || !this.isHtml || !this.isHTMLRenderingEnabled()) {
            this.putClientProperty("html", null);
            return;
        }
        View customHtmlView = this.createHTMLView(HTML_TAG + text);
        this.putClientProperty("html", customHtmlView);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isUpdating) {
            return;
        }
        String name = evt.getPropertyName();
        if (!"html".equals(name)) {
            return;
        }
        try {
            this.isUpdating = true;
            this.updateHtmlView();
        }
        finally {
            this.isUpdating = false;
        }
    }

    private View createHTMLView(String html) {
        if (this.getFont() == null) {
            return null;
        }
        GHtmlLabelEditorKit editorKit = new GHtmlLabelEditorKit();
        Document document = editorKit.createDefaultDocument(this.getFont(), this.getForeground());
        if (document == null) {
            return null;
        }
        StringReader reader = new StringReader(html);
        try {
            editorKit.read(reader, document, 0);
        }
        catch (Throwable e) {
            Msg.debug((Object)this, (Object)"Error loading default html styles", (Throwable)e);
            return null;
        }
        ViewFactory factory = editorKit.getViewFactory();
        View view = factory.create(document.getDefaultRootElement());
        return new ViewWrapper(this, view, factory);
    }

    private class GHtmlLabelEditorKit
    extends HTMLEditorKit {
        private GHtmlLabelEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet baseStyleSheet = this.getStyleSheet();
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.addStyleSheet(baseStyleSheet);
            GHtmlLabelDocument document = new GHtmlLabelDocument(styleSheet, AbstractHtmlLabel.this.getFont(), AbstractHtmlLabel.this.getBackground());
            document.setParser(this.getParser());
            document.setAsynchronousLoadPriority(4);
            document.setTokenThreshold(100);
            return document;
        }

        public Document createDefaultDocument(Font defaultFont, Color foreground) {
            StyleSheet defaultStyleSheet = new StyleSheet();
            String defaultCss = "p {\n\tmargin-top: 0;\n\tmargin-bottom: 0;\n\tmargin-left: 0;\n\tmargin-right: 0;\n}\nbody {\n\tmargin-top: 0;\n\tmargin-bottom: 0;\n\tmargin-left: 0;\n\tmargin-right: 0;\n}\n";
            StringReader reader = new StringReader(defaultCss);
            try {
                defaultStyleSheet.loadRules(reader, null);
            }
            catch (Throwable e) {
                Msg.debug((Object)this, (Object)"Error loading default html styles", (Throwable)e);
                return null;
            }
            defaultStyleSheet.addStyleSheet(super.getStyleSheet());
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.addStyleSheet(defaultStyleSheet);
            GHtmlLabelDocument document = new GHtmlLabelDocument(styleSheet, defaultFont, foreground);
            document.setAsynchronousLoadPriority(Integer.MAX_VALUE);
            return document;
        }
    }

    private class ViewWrapper
    extends View {
        private int width;
        private View htmlView;
        private ViewFactory factory;
        private JComponent container;

        ViewWrapper(AbstractHtmlLabel abstractHtmlLabel, View view, ViewFactory viewFactory) {
            super(null);
            this.container = abstractHtmlLabel;
            this.htmlView = view;
            this.factory = viewFactory;
            this.htmlView.setParent(this);
            this.setSize(this.htmlView.getPreferredSpan(0), this.htmlView.getPreferredSpan(1));
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                return this.width;
            }
            return this.htmlView.getPreferredSpan(axis);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return this.htmlView.getMinimumSpan(axis);
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean w, boolean h) {
            this.container.revalidate();
            this.container.repaint();
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            Rectangle alloc = allocation.getBounds();
            this.htmlView.setSize(alloc.width, alloc.height);
            this.htmlView.paint(g, allocation);
        }

        @Override
        public void setSize(float w, float h) {
            this.width = (int)w;
            this.htmlView.setSize(w, h);
        }

        @Override
        public void setParent(View parent) {
            throw new AssertException("setParent() unexpectedly called");
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public Container getContainer() {
            return this.container;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.htmlView;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return this.htmlView.modelToView(pos, a, b);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            return this.htmlView.modelToView(p0, b0, p1, b1, a);
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            return this.htmlView.viewToModel(x, y, a, bias);
        }

        @Override
        public Document getDocument() {
            return this.htmlView.getDocument();
        }

        @Override
        public int getStartOffset() {
            return this.htmlView.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.htmlView.getEndOffset();
        }

        @Override
        public Element getElement() {
            return this.htmlView.getElement();
        }

        @Override
        public float getAlignment(int axis) {
            return this.htmlView.getAlignment(axis);
        }
    }

    private class GHtmlLabelReader
    extends HTMLDocument.HTMLReader {
        public GHtmlLabelReader(AbstractHtmlLabel abstractHtmlLabel, HTMLDocument htmlDocument, int offset) {
            HTMLDocument hTMLDocument = htmlDocument;
            Objects.requireNonNull(hTMLDocument);
            super(hTMLDocument, offset);
            HTMLDocument.HTMLReader.TagAction stub = new HTMLDocument.HTMLReader.TagAction(this);
            HTML.Tag[] toRemove = new HTML.Tag[]{HTML.Tag.ADDRESS, HTML.Tag.APPLET, HTML.Tag.AREA, HTML.Tag.BASE, HTML.Tag.BASEFONT, HTML.Tag.BIG, HTML.Tag.CAPTION, HTML.Tag.CITE, HTML.Tag.DD, HTML.Tag.DFN, HTML.Tag.DIR, HTML.Tag.DL, HTML.Tag.DT, HTML.Tag.EM, HTML.Tag.FORM, HTML.Tag.FRAME, HTML.Tag.FRAMESET, HTML.Tag.HEAD, HTML.Tag.IMG, HTML.Tag.INPUT, HTML.Tag.ISINDEX, HTML.Tag.KBD, HTML.Tag.LINK, HTML.Tag.MAP, HTML.Tag.MENU, HTML.Tag.META, HTML.Tag.NOFRAMES, HTML.Tag.OBJECT, HTML.Tag.OPTION, HTML.Tag.PARAM, HTML.Tag.SAMP, HTML.Tag.SCRIPT, HTML.Tag.SELECT, HTML.Tag.SMALL, HTML.Tag.S, HTML.Tag.STRONG, HTML.Tag.STYLE, HTML.Tag.TITLE, HTML.Tag.VAR};
            this.replace(toRemove, stub);
        }

        private void replace(HTML.Tag[] tags, HTMLDocument.HTMLReader.TagAction action) {
            for (HTML.Tag tag : tags) {
                this.registerTag(tag, action);
            }
        }
    }

    private class GHtmlLabelDocument
    extends HTMLDocument {
        public GHtmlLabelDocument(StyleSheet ss, Font font, Color bg) {
            super(ss);
            this.setPreservesUnknownTags(false);
            String s = "body {\n\tfont-family: %s;\n\tfont-size: %spt;\n\tfont-weight: %s;\n\tfont-style: %s;\n\tcolor: %s;\n}\n";
            String family = font.getFamily();
            String size = Integer.toString(font.getSize());
            String weight = font.isBold() ? "700" : "400";
            String style = font.isItalic() ? "italic" : "normal";
            String color = WebColors.toString((Color)bg, (boolean)false);
            String css = String.format(s, family, size, weight, style, color);
            ss.addRule(css);
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos) {
            return new GHtmlLabelReader(AbstractHtmlLabel.this, this, pos);
        }
    }
}

