/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class PdbDataTypeParser {
    private static final String NO_TYPE = "<NoType>";
    private static final WrappedDataType NO_TYPE_DATATYPE = new WrappedDataType((DataType)new TypedefDataType("<NoType>", (DataType)Undefined1DataType.dataType), false, true);
    private DataTypeManager programDataTypeMgr;
    private DataTypeManagerService service;
    private TaskMonitor monitor;
    private boolean bitfieldHasMissingBitOffset = false;
    private Map<String, DataType> dataTypeCache = new HashMap<String, DataType>();

    PdbDataTypeParser(DataTypeManager programDataTypeMgr, DataTypeManagerService service, TaskMonitor monitor) {
        this.programDataTypeMgr = programDataTypeMgr;
        this.service = service;
        this.monitor = monitor;
        this.createMandatoryDataTypes();
    }

    private void createMandatoryDataTypes() {
        this.cachePrimitiveDataType((DataType)new TypedefDataType("wchar", (DataType)WideCharDataType.dataType));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__int8", AbstractIntegerDataType.getSignedDataType((int)1, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__uint8", AbstractIntegerDataType.getUnsignedDataType((int)1, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__int16", AbstractIntegerDataType.getSignedDataType((int)2, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__uint16", AbstractIntegerDataType.getUnsignedDataType((int)2, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__int32", AbstractIntegerDataType.getSignedDataType((int)4, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__uint32", AbstractIntegerDataType.getUnsignedDataType((int)2, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__int64", AbstractIntegerDataType.getSignedDataType((int)8, (DataTypeManager)this.programDataTypeMgr)));
        this.cachePrimitiveDataType((DataType)new TypedefDataType("__uint64", AbstractIntegerDataType.getUnsignedDataType((int)8, (DataTypeManager)this.programDataTypeMgr)));
    }

    public DataTypeManager getProgramDataTypeManager() {
        return this.programDataTypeMgr;
    }

    void flushDataTypeCache() throws CancelledException {
        this.programDataTypeMgr.addDataTypes(this.dataTypeCache.values(), DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER, this.monitor);
    }

    void clear() {
        this.dataTypeCache = new HashMap<String, DataType>();
    }

    DataType getCachedDataType(String key) {
        return this.dataTypeCache.get(key);
    }

    void cacheDataType(String key, DataType dataType) {
        this.dataTypeCache.put(key, dataType);
    }

    void cachePrimitiveDataType(DataType dataType) {
        this.dataTypeCache.put(dataType.getName(), dataType);
    }

    private DataType findDataTypeInArchives(String datatype, TaskMonitor monitor) throws CancelledException {
        DataTypeManager[] managers = this.service.getDataTypeManagers();
        Arrays.sort(managers, new PdbDataTypeManagerComparator());
        for (DataTypeManager manager : managers) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            DataType dt = DataTypeUtilities.findNamespaceQualifiedDataType((DataTypeManager)manager, (String)datatype, null);
            if (dt == null) continue;
            this.cacheDataType(datatype, dt);
            return dt;
        }
        return null;
    }

    private DataType findBaseDataType(String dataTypeName, TaskMonitor monitor) throws CancelledException {
        DataType dt = this.getCachedDataType(dataTypeName);
        if (dt != null) {
            return dt;
        }
        BuiltInDataTypeManager builtInDTM = BuiltInDataTypeManager.getDataTypeManager();
        dt = builtInDTM.getDataType(new DataTypePath(CategoryPath.ROOT, dataTypeName));
        if (dt == null) {
            dt = this.findDataTypeInArchives(dataTypeName, monitor);
        }
        return dt;
    }

    public WrappedDataType findDataType(String datatype) throws CancelledException {
        DataType dt;
        if ((datatype = datatype.trim()) == null || datatype.length() == 0) {
            return null;
        }
        if (NO_TYPE.equals(datatype)) {
            return NO_TYPE_DATATYPE;
        }
        Object dataTypeName = datatype;
        if (((String)dataTypeName).startsWith("*") || ((String)dataTypeName).startsWith("[")) {
            Msg.warn((Object)this, (Object)("dataTypeName \"" + (String)dataTypeName + "\" references a pointer or array without a declared datatype; assuming undefined"));
            dataTypeName = "undefined" + (String)dataTypeName;
        }
        dataTypeName = StringUtils.replace((String)dataTypeName, (String)NO_TYPE, (String)"undefined");
        int basePointerDepth = 0;
        while (((String)dataTypeName).endsWith("*")) {
            ++basePointerDepth;
            dataTypeName = ((String)dataTypeName).substring(0, ((String)dataTypeName).length() - 1).trim();
        }
        boolean isZeroLengthArray = false;
        ArrayList<Integer> arrayDimensions = null;
        if (((String)dataTypeName).endsWith("]")) {
            arrayDimensions = new ArrayList<Integer>();
            if ((dataTypeName = this.parseArrayDimensions((String)dataTypeName, arrayDimensions)) == null) {
                Msg.error((Object)this, (Object)("Failed to parse array dimensions: " + datatype));
                return null;
            }
            isZeroLengthArray = (Integer)arrayDimensions.get(arrayDimensions.size() - 1) == 0;
        }
        int pointerDepth = 0;
        if (arrayDimensions != null) {
            while (((String)dataTypeName).endsWith("*")) {
                ++pointerDepth;
                dataTypeName = ((String)dataTypeName).substring(0, ((String)dataTypeName).length() - 1).trim();
            }
            if (pointerDepth != 0 && isZeroLengthArray) {
                Msg.error((Object)this, (Object)("Unsupported pointer to zero-length array: " + datatype));
                return null;
            }
        }
        if ((dt = this.findBaseDataType((String)dataTypeName, this.monitor)) == null) {
            return null;
        }
        while (basePointerDepth-- != 0) {
            dt = this.createPointer(dt);
        }
        if (arrayDimensions != null) {
            dt = this.createArray(dt, arrayDimensions);
        }
        while (pointerDepth-- != 0) {
            dt = this.createPointer(dt);
        }
        return new WrappedDataType(dt, isZeroLengthArray, false);
    }

    private String parseArrayDimensions(String datatype, List<Integer> arrayDimensions) {
        String dataTypeName = datatype;
        boolean zeroLengthArray = false;
        while (dataTypeName.endsWith("]")) {
            int dimension;
            if (zeroLengthArray) {
                return null;
            }
            int rBracketPos = dataTypeName.lastIndexOf(93);
            int lBracketPos = dataTypeName.lastIndexOf(91);
            if (lBracketPos < 0) {
                return null;
            }
            try {
                dimension = Integer.parseInt(dataTypeName.substring(lBracketPos + 1, rBracketPos));
                if (dimension < 0) {
                    return null;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            dataTypeName = dataTypeName.substring(0, lBracketPos).trim();
            arrayDimensions.add(dimension);
        }
        return dataTypeName;
    }

    DataType createPointer(DataType dt) {
        return PointerDataType.getPointer((DataType)dt, (DataTypeManager)this.programDataTypeMgr);
    }

    private DataType createArray(DataType dt, List<Integer> arrayDimensions) {
        boolean zeroLengthArray;
        int dimensionCount = arrayDimensions.size();
        boolean bl = zeroLengthArray = arrayDimensions.get(arrayDimensions.size() - 1) == 0;
        if (zeroLengthArray) {
            --dimensionCount;
        }
        for (int i = 0; i < dimensionCount; ++i) {
            int dimension = arrayDimensions.get(i);
            dt = new ArrayDataType(dt, dimension, dt.getLength(), this.programDataTypeMgr);
        }
        if (zeroLengthArray) {
            dt = new ArrayDataType(dt, 1, dt.getLength(), this.programDataTypeMgr);
        }
        return dt;
    }

    void setMissingBitOffsetError() {
        this.bitfieldHasMissingBitOffset = true;
    }

    boolean hasMissingBitOffsetError() {
        return this.bitfieldHasMissingBitOffset;
    }

    private class PdbDataTypeManagerComparator
    implements Comparator<DataTypeManager> {
        private PdbDataTypeManagerComparator() {
        }

        @Override
        public int compare(DataTypeManager dtm1, DataTypeManager dtm2) {
            if (dtm1 == PdbDataTypeParser.this.programDataTypeMgr) {
                return -1;
            }
            if (dtm2 == PdbDataTypeParser.this.programDataTypeMgr) {
                return 1;
            }
            if (dtm1 instanceof BuiltInDataTypeManager) {
                return -1;
            }
            if (dtm2 instanceof BuiltInDataTypeManager) {
                return 1;
            }
            return 0;
        }
    }
}

