/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import java.io.IOException;

class MsfFileReader
implements AutoCloseable {
    private ByteProvider byteProvider;
    private Msf msf;

    @Override
    public void close() throws IOException {
        if (this.byteProvider != null) {
            this.byteProvider.close();
        }
    }

    MsfFileReader(Msf msf, ByteProvider byteProvider) {
        this.msf = msf;
        this.byteProvider = byteProvider;
    }

    void readPage(int page, byte[] bytes) throws IOException {
        this.read(page, 0, this.msf.getPageSize(), bytes, 0);
    }

    void read(int page, int offset, int numToRead, byte[] bytes, int bytesOffset) throws IOException {
        if (numToRead < 1) {
            throw new IOException("Must request at least one byte in MSF read");
        }
        if (offset < 0 || offset >= this.msf.getPageSize()) {
            throw new IOException(String.format("Offset must be in range [0, %d) in for MSF read", this.msf.getPageSize()));
        }
        long fileOffset = (long)offset + (long)page * (long)this.msf.getPageSize();
        if (Msf.floorDivisionWithLog2Divisor(offset + numToRead, this.msf.getLog2PageSize()) > this.msf.getNumPages()) {
            throw new IOException("Invalid MSF configuration");
        }
        System.arraycopy(this.byteProvider.readBytes(fileOffset, (long)numToRead), 0, bytes, bytesOffset, numToRead);
    }
}

