/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardRepulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class StandardFRRepulsion<V, R extends StandardFRRepulsion<V, R, B>, B extends Builder<V, R, B>>
implements StandardRepulsion<V, R, B> {
    protected Map<V, Point> frVertexData;
    protected Function<V, Point> initializer;
    protected double repulsionConstant;
    protected double EPSILON = 1.0E-6;
    protected Random random = new Random();
    protected LayoutModel<V> layoutModel;
    protected Set<V> vertexSet;
    double repulsionSquared;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder standardBuilder() {
        return StandardFRRepulsion.builder();
    }

    protected StandardFRRepulsion(Builder<V, R, B> builder) {
        this.layoutModel = builder.layoutModel;
        this.vertexSet = this.layoutModel.getGraph().vertexSet();
        this.random = builder.random;
        this.frVertexData = builder.frVertexData;
        this.initializer = builder.initializer;
        this.repulsionConstant = builder.repulsionConstant;
        this.repulsionSquared = this.repulsionConstant * this.repulsionConstant;
    }

    @Override
    public void step() {
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public void calculateRepulsion() {
        for (V vertex1 : this.vertexSet) {
            Point fvd1 = Point.ORIGIN;
            Point p1 = (Point)this.layoutModel.apply(vertex1);
            try {
                for (V vertex2 : this.vertexSet) {
                    if (vertex1 == vertex2) continue;
                    Point p2 = (Point)this.layoutModel.apply(vertex2);
                    if (p1 == null || p2 == null) continue;
                    double dx = p1.x - p2.x;
                    double dy = p1.y - p2.y;
                    double dist = Math.max(this.EPSILON, Math.sqrt(dx * dx + dy * dy));
                    double force = this.repulsionSquared / dist;
                    if (Double.isNaN(force)) {
                        throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                    }
                    fvd1 = fvd1.add(dx / dist * force, dy / dist * force);
                }
                this.frVertexData.put((Point)vertex1, fvd1);
            }
            catch (ConcurrentModificationException cme) {
                this.calculateRepulsion();
            }
        }
    }

    public static class Builder<V, R extends StandardFRRepulsion<V, R, B>, B extends Builder<V, R, B>>
    implements StandardRepulsion.Builder<V, R, B> {
        protected Map<V, Point> frVertexData;
        protected Function<V, Point> initializer = v -> Point.ORIGIN;
        protected double repulsionConstant;
        protected Random random = new Random();
        protected LayoutModel<V> layoutModel;

        public B nodeData(Map<V, Point> frVertexData) {
            this.frVertexData = frVertexData;
            return (B)this;
        }

        public B initializer(Function<V, Point> initializer) {
            this.initializer = initializer;
            return (B)this;
        }

        public B repulsionConstant(double repulstionConstant) {
            this.repulsionConstant = repulstionConstant;
            return (B)this;
        }

        @Override
        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return (B)this;
        }

        @Override
        public B random(Random random) {
            this.random = random;
            return (B)this;
        }

        @Override
        public R build() {
            return (R)new StandardFRRepulsion(this);
        }
    }
}

