/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util;

import java.io.InputStream;
import java.util.Properties;

public class PropertyLoader {
    public static final String PREFIX = "jungrapht.";
    private static boolean loaded;
    private static final String PROPERTIES_FILE_NAME;

    public static void load() {
        if (!loaded) {
            PropertyLoader.loadFromDefault();
            PropertyLoader.loadFromAppName();
            loaded = true;
        }
    }

    private PropertyLoader() {
    }

    private static boolean loadFromAppName() {
        try {
            Object launchProgram = System.getProperty("sun.java.command");
            if (launchProgram != null && !((String)launchProgram).isEmpty()) {
                launchProgram = ((String)launchProgram).substring(((String)launchProgram).lastIndexOf(46) + 1) + ".properties";
                InputStream stream = PropertyLoader.class.getResourceAsStream("/" + (String)launchProgram);
                System.getProperties().load(stream);
                Properties props = System.getProperties();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean loadFromDefault() {
        try {
            InputStream stream = PropertyLoader.class.getResourceAsStream("/" + PROPERTIES_FILE_NAME);
            System.getProperties().load(stream);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        PROPERTIES_FILE_NAME = System.getProperty("jungrapht.properties.file.name", "jungrapht.properties");
    }
}

