/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.ShortListIndexer;
import ghidra.util.exception.AssertException;
import java.io.Serializable;

public class ShortKeyIndexer
implements Serializable {
    private static final short DEFAULT_CAPACITY = 13;
    private short[] keys;
    private ShortListIndexer indexer;
    private short capacity;

    public ShortKeyIndexer() {
        this(13);
    }

    public ShortKeyIndexer(short capacity) {
        this.capacity = capacity = (short)Prime.nextPrime(capacity);
        this.indexer = new ShortListIndexer(capacity, capacity);
        this.keys = new short[capacity];
    }

    public short put(short key) {
        short index = this.findKey(key);
        if (index == -1) {
            short hashcode;
            if (this.indexer.getSize() >= this.capacity) {
                this.grow();
            }
            if ((index = this.indexer.add(hashcode = (short)((key & Short.MAX_VALUE) % this.capacity))) < 0) {
                throw new IndexOutOfBoundsException("Maximum capacity reached");
            }
            this.keys[index] = key;
        }
        return index;
    }

    public short get(short key) {
        return this.findKey(key);
    }

    public short remove(short key) {
        short index = this.findKey(key);
        if (index == -1) {
            return -1;
        }
        short hashcode = (short)((key & Short.MAX_VALUE) % this.capacity);
        this.indexer.remove(hashcode, index);
        return index;
    }

    public short getSize() {
        return this.indexer.getSize();
    }

    public short getCapacity() {
        return this.capacity;
    }

    public void clear() {
        this.indexer.clear();
    }

    public short[] getKeys() {
        short[] keyArray = new short[this.getSize()];
        int pos = 0;
        short nLists = this.indexer.getNumLists();
        for (short i = 0; i < nLists; i = (short)(i + 1)) {
            short keyIndex = this.indexer.first(i);
            while (keyIndex >= 0) {
                keyArray[pos++] = this.keys[keyIndex];
                keyIndex = this.indexer.next(keyIndex);
            }
        }
        if (pos != this.getSize()) {
            throw new AssertException("Trouble in IntKeyIndexer.getKeys(), size = " + this.getSize() + "  pos= " + pos);
        }
        return keyArray;
    }

    private short findKey(short key) {
        short hashcode = (short)((key & Short.MAX_VALUE) % this.capacity);
        short p = this.indexer.first(hashcode);
        while (p != -1) {
            if (this.keys[p] == key) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }

    private void grow() {
        short newCapacity = (short)Prime.nextPrime(this.indexer.getNewCapacity());
        this.indexer.growCapacity(newCapacity);
        this.indexer.growNumLists(newCapacity);
        this.indexer.clear();
        short[] oldKeys = this.keys;
        this.keys = new short[newCapacity];
        this.capacity = newCapacity;
        for (int i = 0; i < oldKeys.length; i = (int)((short)(i + 1))) {
            this.put(oldKeys[i]);
        }
    }
}

