/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.BasicEdgeLabelRenderer;
import ghidra.graph.viewer.renderer.GridPainter;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;

public class VisualGraphRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends BasicRenderer<V, E> {
    private static GridPainter gridPainter;
    private Renderer.EdgeLabel<V, E> edgeLabelRenderer = new BasicEdgeLabelRenderer();

    public static void setGridPainter(GridPainter gridPainter) {
        VisualGraphRenderer.gridPainter = gridPainter;
    }

    public VisualGraphRenderer(Renderer.EdgeLabel<V, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    public void render(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        try {
            this.mimickSuperPaintingWithoutPaintingSelectedVertices(renderContext, layout);
        }
        catch (Exception e) {
            if (e instanceof ConcurrentModificationException) {
                return;
            }
            throw e;
        }
    }

    private void mimickSuperPaintingWithoutPaintingSelectedVertices(RenderContext<V, E> renderContext, Layout<V, E> layout) {
        if (gridPainter != null) {
            gridPainter.paintLayoutGridCells(renderContext, layout);
        }
        for (VisualEdge e : layout.getGraph().getEdges()) {
            this.renderEdge(renderContext, layout, e);
            this.renderEdgeLabel(renderContext, layout, (E)e);
        }
        Collection defaultVertices = layout.getGraph().getVertices();
        List<VisualVertex> vertices = GraphViewerUtils.createCollectionWithZOrderBySelection(defaultVertices);
        for (VisualVertex v : vertices) {
            this.renderVertex(renderContext, layout, v);
            this.renderVertexLabel(renderContext, layout, (V)v);
        }
    }

    public void renderVertexLabel(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        String label = (String)rc.getVertexLabelTransformer().apply(v);
        if (label == null) {
            return;
        }
        super.renderVertexLabel(rc, layout, v);
    }

    public void renderEdgeLabel(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        if (this.edgeLabelRenderer == null) {
            return;
        }
        Function xform = rc.getEdgeLabelTransformer();
        String label = (String)xform.apply(e);
        if (label == null) {
            return;
        }
        this.edgeLabelRenderer.labelEdge(rc, layout, e, (String)xform.apply(e));
    }
}

