/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphLabelPosition;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;
import java.awt.Color;
import java.util.Objects;

public class GraphDisplayOptionsBuilder {
    private GraphDisplayOptions displayOptions;

    public GraphDisplayOptionsBuilder(GraphType graphType) {
        this.displayOptions = new GraphDisplayOptions(graphType);
    }

    public GraphDisplayOptionsBuilder defaultVertexColor(Color c) {
        this.displayOptions.setDefaultVertexColor(c);
        return this;
    }

    public GraphDisplayOptionsBuilder defaultEdgeColor(Color c) {
        Objects.requireNonNull(c);
        this.displayOptions.setDefaultEdgeColor(c);
        return this;
    }

    public GraphDisplayOptionsBuilder vertexSelectionColor(Color color) {
        this.displayOptions.setVertexSelectionColor(color);
        return this;
    }

    public GraphDisplayOptionsBuilder edgeSelectionColor(Color color) {
        this.displayOptions.setEdgeSelectionColor(color);
        return this;
    }

    public GraphDisplayOptionsBuilder defaultVertexShape(VertexShape vertexShape) {
        Objects.requireNonNull(vertexShape);
        this.displayOptions.setDefaultVertexShape(vertexShape);
        return this;
    }

    public GraphDisplayOptionsBuilder vertex(String vertexType, VertexShape vertexShape, Color color) {
        this.displayOptions.configureVertexType(vertexType, vertexShape, color);
        return this;
    }

    public GraphDisplayOptionsBuilder edge(String edgeType, Color color) {
        this.displayOptions.configureEdgeType(edgeType, color);
        return this;
    }

    public GraphDisplayOptionsBuilder vertexColorOverrideAttribute(String colorAttributeKey) {
        this.displayOptions.setVertexColorOverrideAttributeKey(colorAttributeKey);
        return this;
    }

    public GraphDisplayOptionsBuilder edgeColorOverrideAttribute(String colorAttributeKey) {
        this.displayOptions.setEdgeColorOverrideAttributeKey(colorAttributeKey);
        return this;
    }

    public GraphDisplayOptionsBuilder shapeOverrideAttribute(String shapeAttributeKey) {
        this.displayOptions.setVertexShapeOverrideAttributeKey(shapeAttributeKey);
        return this;
    }

    public GraphDisplayOptionsBuilder defaultLayoutAlgorithm(String string) {
        this.displayOptions.setDefaultLayoutAlgorithmName(string);
        return this;
    }

    public GraphDisplayOptionsBuilder useIcons(boolean b) {
        this.displayOptions.setUsesIcons(b);
        return this;
    }

    public GraphDisplayOptionsBuilder arrowLength(int length) {
        this.displayOptions.setArrowLength(length);
        return this;
    }

    public GraphDisplayOptionsBuilder maxNodeCount(int maxNodeCount) {
        this.displayOptions.setMaxNodeCount(maxNodeCount);
        return this;
    }

    public GraphDisplayOptionsBuilder labelPosition(GraphLabelPosition labelPosition) {
        this.displayOptions.setLabelPosition(labelPosition);
        return this;
    }

    public GraphDisplayOptions build() {
        return this.displayOptions;
    }
}

