/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;

public class OpTplWalker {
    private ConstructState point;
    private OpTpl[] oparray;
    private int depth;
    private int[] breadcrumb;
    private int maxsize;
    private int sectionnum;

    private void setupPoint() {
        ConstructTpl tpl;
        this.maxsize = 0;
        this.oparray = null;
        Constructor ct = this.point.getConstructor();
        if (ct == null) {
            return;
        }
        if (this.sectionnum < 0) {
            tpl = ct.getTempl();
            if (tpl == null) {
                return;
            }
        } else {
            tpl = ct.getNamedTempl(this.sectionnum);
        }
        if (tpl == null) {
            this.maxsize = ct.getNumOperands();
        } else {
            this.oparray = tpl.getOpVec();
            this.maxsize = this.oparray.length;
        }
    }

    public OpTplWalker(ConstructState root, int sectionnum) {
        this.sectionnum = sectionnum;
        this.point = root;
        this.breadcrumb = new int[64];
        this.depth = 0;
        this.breadcrumb[0] = 0;
        this.setupPoint();
    }

    public OpTplWalker(ConstructTpl tpl) {
        this.point = null;
        this.breadcrumb = new int[1];
        this.depth = 0;
        this.breadcrumb[0] = 0;
        this.oparray = tpl.getOpVec();
        this.maxsize = this.oparray.length;
    }

    public ConstructState getState() {
        return this.point;
    }

    public boolean isState() {
        if (this.point != null) {
            return true;
        }
        return this.maxsize > 0;
    }

    public void pushBuild(int buildnum) {
        this.point = this.point.getSubState(buildnum);
        ++this.depth;
        this.breadcrumb[this.depth] = 0;
        this.setupPoint();
    }

    public void popBuild() {
        if (this.point == null) {
            this.maxsize = 0;
            this.oparray = null;
            return;
        }
        this.point = this.point.getParent();
        --this.depth;
        if (this.point != null) {
            this.setupPoint();
        } else {
            this.maxsize = 0;
            this.oparray = null;
        }
    }

    public Object nextOpTpl() {
        int n = this.depth;
        int n2 = this.breadcrumb[n];
        this.breadcrumb[n] = n2 + 1;
        int curind = n2;
        if (curind >= this.maxsize) {
            return null;
        }
        if (this.oparray == null) {
            return curind;
        }
        OpTpl op = this.oparray[curind];
        if (op.getOpcode() != 60) {
            return op;
        }
        curind = (int)op.getInput()[0].getOffset().getReal();
        return curind;
    }
}

