/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;

public class PcodeEmitObjects
extends PcodeEmit {
    private ArrayList<PcodeOp> oplist = new ArrayList();
    private ArrayList<Integer> labelref = null;

    public PcodeEmitObjects(ParserWalker walk) {
        this(walk, null, 0, null);
    }

    public PcodeEmitObjects(ParserWalker walk, int fallOffset) {
        this(walk, null, fallOffset, null);
    }

    public PcodeEmitObjects(ParserWalker walk, InstructionContext ictx, int fallOffset, PcodeOverride override) {
        super(walk, ictx, fallOffset, override);
    }

    public PcodeOp[] getPcodeOp() {
        PcodeOp[] retop = new PcodeOp[this.oplist.size()];
        this.oplist.toArray(retop);
        return retop;
    }

    @Override
    public void resolveRelatives() {
        if (this.labelref == null) {
            return;
        }
        for (Integer opindex : this.labelref) {
            PcodeOp op = this.oplist.get(opindex);
            Varnode vn = op.getInput(0);
            int labelid = (int)vn.getOffset();
            if (labelid >= this.labeldef.size() || this.labeldef.get(labelid) == null) {
                throw new SleighException("Reference to non-existant sleigh label");
            }
            long res = (long)((Integer)this.labeldef.get(labelid)).intValue() - (long)opindex.intValue();
            if (vn.getSize() < 8) {
                long mask = -1L;
                res &= (mask >>>= (8 - vn.getSize()) * 8);
            }
            AddressSpace spc = vn.getAddress().getAddressSpace();
            vn = new Varnode(spc.getAddress(res), vn.getSize());
            op.setInput(vn, 0);
        }
    }

    @Override
    void addLabelRef() {
        if (this.labelref == null) {
            this.labelref = new ArrayList();
        }
        this.labelref.add(this.numOps);
    }

    @Override
    void dump(Address instrAddr, int opcode, VarnodeData[] in, int isize, VarnodeData out) {
        int updatedOpcode = this.checkOverrides(opcode, in);
        Varnode outvn = out != null ? new Varnode(out.space.getAddress(out.offset), out.size) : null;
        if (opcode == 9 && updatedOpcode == 7) {
            isize = 1;
        }
        Varnode[] invn = new Varnode[isize];
        for (int i = 0; i < isize; ++i) {
            invn[i] = new Varnode(in[i].space.getAddress(in[i].offset), in[i].size);
        }
        PcodeOp op = new PcodeOp(instrAddr, this.oplist.size(), updatedOpcode, invn, outvn);
        this.oplist.add(op);
    }
}

