/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.Table;
import ghidra.program.database.data.ParentChildAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

class ParentChildDBAdapterV0
extends ParentChildAdapter {
    private static final int VERSION = 0;
    private static final int PARENT_COL = 0;
    private static final int CHILD_COL = 1;
    static final Schema V0_SCHEMA = new Schema(0, "KEY", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Parent ID", "Child ID"});
    private Table table;
    private boolean needsInitializing = false;

    ParentChildDBAdapterV0(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "DT_PARENT_CHILD";
        if (create) {
            this.table = handle.createTable(tableName, V0_SCHEMA, new int[]{0, 1});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    @Override
    public void createRecord(long parentID, long childID) throws IOException {
        long key = this.table.getKey();
        DBRecord record = V0_SCHEMA.createRecord(key);
        record.setLongValue(0, parentID);
        record.setLongValue(1, childID);
        this.table.putRecord(record);
    }

    @Override
    void removeRecord(long parentID, long childID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(childID), 1)) {
            DBRecord rec = this.table.getRecord(id);
            if (rec.getLongValue(0) != parentID) continue;
            this.table.deleteRecord(id);
            return;
        }
    }

    @Override
    Set<Long> getChildIds(long parentID) throws IOException {
        Field[] ids = this.table.findRecords((Field)new LongField(parentID), 0);
        HashSet<Long> childIds = new HashSet<Long>(ids.length);
        for (Field id : ids) {
            DBRecord rec = this.table.getRecord(id);
            childIds.add(rec.getLongValue(1));
        }
        return childIds;
    }

    @Override
    Set<Long> getParentIds(long childID) throws IOException {
        Field[] ids = this.table.findRecords((Field)new LongField(childID), 1);
        HashSet<Long> parentIds = new HashSet<Long>(ids.length);
        for (Field id : ids) {
            DBRecord rec = this.table.getRecord(id);
            parentIds.add(rec.getLongValue(0));
        }
        return parentIds;
    }

    @Override
    boolean hasParent(long childID) throws IOException {
        return this.table.hasRecord((Field)new LongField(childID), 1);
    }

    public void setNeedsInitializing() {
        this.needsInitializing = true;
    }

    @Override
    boolean needsInitializing() {
        return this.needsInitializing;
    }

    @Override
    void removeAllRecordsForParent(long parentID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(parentID), 0)) {
            this.table.deleteRecord(id);
        }
    }

    @Override
    void removeAllRecordsForChild(long childID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(childID), 1)) {
            this.table.deleteRecord(id);
        }
    }
}

