/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.program.database.data.SettingsDBAdapterV1;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class SettingsDBAdapterV0
extends SettingsDBAdapter {
    static final int V0_SETTINGS_ASSOCIATION_ID_COL = 0;
    static final int V0_SETTINGS_NAME_COL = 1;
    static final int V0_SETTINGS_LONG_VALUE_COL = 2;
    static final int V0_SETTINGS_STRING_VALUE_COL = 3;
    private static final int V0_SCHEMA_VERSION = 0;
    private Table settingsTable;
    private HashMap<Short, String> nameIndexMap = new HashMap();
    private HashMap<String, Short> nameStringMap = new HashMap();

    SettingsDBAdapterV0(String tableName, DBHandle handle) throws VersionException {
        this.settingsTable = handle.getTable(tableName);
        if (this.settingsTable == null) {
            throw new VersionException("Missing Table: " + tableName);
        }
        int ver = this.settingsTable.getSchema().getVersion();
        if (ver != 0) {
            throw new VersionException(false);
        }
    }

    @Override
    String getTableName() {
        return this.settingsTable.getName();
    }

    @Override
    public DBRecord createSettingsRecord(long associationId, String name, String strValue, long longValue) throws IOException {
        throw new ReadOnlyException();
    }

    @Override
    public Field[] getSettingsKeys(long associationId) throws IOException {
        return this.settingsTable.findRecords((Field)new LongField(associationId), 0);
    }

    @Override
    void removeAllSettingsRecords(long associationId) throws IOException {
        for (Field key : this.getSettingsKeys(associationId)) {
            this.removeSettingsRecord(key.getLongValue());
        }
    }

    @Override
    public boolean removeSettingsRecord(long settingsID) throws IOException {
        throw new ReadOnlyException();
    }

    @Override
    boolean removeSettingsRecord(long associationId, String name) throws IOException {
        throw new ReadOnlyException();
    }

    @Override
    String[] getSettingsNames(long associationId) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (Field key : this.getSettingsKeys(associationId)) {
            DBRecord rec = this.settingsTable.getRecord(key);
            list.add(rec.getString(1));
        }
        String[] names = new String[list.size()];
        return list.toArray(names);
    }

    @Override
    void addAllValues(String name, Set<String> set) throws IOException {
        for (DBRecord rec : this.settingsTable) {
            String s;
            if (!name.equals(rec.getString(1)) || StringUtils.isBlank((CharSequence)(s = rec.getString(3)))) continue;
            set.add(s);
        }
    }

    @Override
    protected String getSettingName(DBRecord normalizedRecord) {
        short nameIndex = normalizedRecord.getShortValue(1);
        return this.nameIndexMap.get(nameIndex);
    }

    @Override
    void invalidateNameCache() {
    }

    private short assignNameIndexValue(String name) {
        Short index = this.nameStringMap.get(name);
        if (index == null) {
            index = (short)this.nameStringMap.size();
            this.nameStringMap.put(name, index);
            this.nameIndexMap.put(index, name);
        }
        return index;
    }

    @Override
    public DBRecord getSettingsRecord(long settingsID) throws IOException {
        return this.translateV0Record(this.settingsTable.getRecord(settingsID));
    }

    @Override
    DBRecord getSettingsRecord(long associationId, String name) throws IOException {
        for (Field key : this.getSettingsKeys(associationId)) {
            DBRecord rec = this.settingsTable.getRecord(key);
            if (!rec.getString(1).equals(name)) continue;
            return this.translateV0Record(rec);
        }
        return null;
    }

    @Override
    public void updateSettingsRecord(DBRecord record) throws IOException {
        throw new ReadOnlyException();
    }

    @Override
    DBRecord updateSettingsRecord(long associationId, String name, String strValue, long longValue) throws IOException {
        throw new ReadOnlyException();
    }

    @Override
    int getRecordCount() {
        return this.settingsTable.getRecordCount();
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.settingsTable.iterator(), r -> this.translateV0Record(r));
    }

    @Override
    RecordIterator getRecords(long minAssociationId, long maxAssociationId) throws IOException {
        return this.settingsTable.indexIterator(0, (Field)new LongField(minAssociationId), (Field)new LongField(maxAssociationId), true);
    }

    @Override
    void delete(long minAssociationId, long maxAssociationId, TaskMonitor monitor) throws CancelledException, IOException {
        throw new ReadOnlyException();
    }

    private DBRecord translateV0Record(DBRecord rec) {
        if (rec == null) {
            return null;
        }
        DBRecord normalizedRecord = SettingsDBAdapterV1.V1_SETTINGS_SCHEMA.createRecord(rec.getKey());
        normalizedRecord.setLongValue(0, rec.getLongValue(0));
        String name = rec.getString(1);
        normalizedRecord.setShortValue(1, this.assignNameIndexValue(name));
        normalizedRecord.setLongValue(2, rec.getLongValue(2));
        normalizedRecord.setString(3, rec.getString(3));
        return normalizedRecord;
    }
}

