/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AbstractAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddress;
import java.util.Objects;

public abstract class OverlayAddressSpace
extends AbstractAddressSpace {
    public static final String OV_SEPARATER = ":";
    private final AddressSpace baseSpace;
    private final String orderedKey;

    public OverlayAddressSpace(AddressSpace baseSpace, int unique, String orderedKey) {
        super(baseSpace.getSize(), baseSpace.getAddressableUnitSize(), baseSpace.getType(), unique);
        this.orderedKey = orderedKey;
        this.baseSpace = baseSpace;
        this.setShowSpaceName(true);
    }

    public String getOrderedKey() {
        return this.orderedKey;
    }

    @Override
    int computeHashCode() {
        return Objects.hash(this.orderedKey, this.baseSpace);
    }

    @Override
    public Address getAddress(String addrString, boolean caseSensitive) throws AddressFormatException {
        addrString = addrString.replaceAll("::", OV_SEPARATER);
        return super.getAddress(addrString, caseSensitive);
    }

    @Override
    public long subtract(Address addr1, Address addr2) {
        AddressSpace space1 = addr1.getAddressSpace();
        AddressSpace space2 = addr2.getAddressSpace();
        if (space1.equals(this)) {
            space1 = this.baseSpace;
        }
        if (space2.equals(this)) {
            space2 = this.baseSpace;
        }
        if (!space1.equals(space2)) {
            throw new IllegalArgumentException("Address are in different spaces " + addr1.getAddressSpace().getName() + " != " + addr2.getAddressSpace().getName());
        }
        return addr1.getOffset() - addr2.getOffset();
    }

    @Override
    public boolean isOverlaySpace() {
        return true;
    }

    public AddressSpace getOverlayedSpace() {
        return this.baseSpace;
    }

    @Override
    public AddressSpace getPhysicalSpace() {
        return this.baseSpace.getPhysicalSpace();
    }

    @Override
    public boolean hasMappedRegisters() {
        return this.baseSpace.hasMappedRegisters();
    }

    public abstract boolean contains(long var1);

    public abstract AddressSetView getOverlayAddressSet();

    @Override
    public Address getAddressInThisSpaceOnly(long offset) {
        return new GenericAddress(offset, this);
    }

    @Override
    public Address getAddress(long offset) {
        if (this.contains(offset)) {
            return new GenericAddress(this, offset);
        }
        return this.baseSpace.getAddress(offset);
    }

    @Override
    protected Address getUncheckedAddress(long offset) {
        return new GenericAddress(offset, this);
    }

    @Override
    public Address getOverlayAddress(Address addr) {
        if (this.getOverlayedSpace().equals(addr.getAddressSpace()) && this.contains(addr.getOffset())) {
            return new GenericAddress(this, addr.getOffset());
        }
        return addr;
    }

    public Address translateAddress(Address addr) {
        return this.translateAddress(addr, false);
    }

    public Address translateAddress(Address addr, boolean forceTranslation) {
        if (addr == null) {
            return null;
        }
        if (!forceTranslation && this.contains(addr.getOffset())) {
            return addr;
        }
        return new GenericAddress(this.baseSpace, addr.getOffset());
    }

    public int getBaseSpaceID() {
        return this.baseSpace.getSpaceID();
    }

    @Override
    public String toString() {
        return super.toString() + OV_SEPARATER;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        OverlayAddressSpace s = (OverlayAddressSpace)obj;
        if (!s.orderedKey.equals(this.orderedKey)) {
            return false;
        }
        if (this.getType() != s.getType() || this.getSize() != s.getSize()) {
            return false;
        }
        return s.getOverlayedSpace().equals(this.baseSpace);
    }

    int compareOverlay(OverlayAddressSpace overlay) {
        if (overlay == this) {
            return 0;
        }
        int rc = this.baseSpace.compareTo(overlay.baseSpace);
        if (rc != 0) {
            return rc;
        }
        int c = this.getType() - overlay.getType();
        if (c == 0) {
            c = this.orderedKey.compareTo(overlay.orderedKey);
        }
        return c;
    }
}

