/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractUnsignedIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IntegerDataType;

public class UnsignedIntegerDataType
extends AbstractUnsignedIntegerDataType {
    public static final UnsignedIntegerDataType dataType = new UnsignedIntegerDataType();

    public UnsignedIntegerDataType() {
        this(null);
    }

    public UnsignedIntegerDataType(DataTypeManager dtm) {
        super("uint", dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getIntegerSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Unsigned Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "unsigned int";
    }

    @Override
    public IntegerDataType getOppositeSignednessDataType() {
        return IntegerDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public UnsignedIntegerDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new UnsignedIntegerDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), "unsigned int", false);
    }
}

