/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;

public class FunctionTagFieldLocation
extends FunctionLocation {
    private String tags;

    public FunctionTagFieldLocation(Program program, Address locationAddr, Address functionAddr, String tags, int charOffset) {
        super(program, locationAddr, functionAddr, 0, 0, charOffset);
        this.tags = tags;
    }

    public FunctionTagFieldLocation() {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionTagFieldLocation other = (FunctionTagFieldLocation)obj;
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Tags: " + this.tags;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_FUNCTION_TAGS", this.tags);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.tags = obj.getString("_FUNCTION_TAGS", null);
    }
}

