/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.ColumnSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.graph.viewer.layout.GridPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColSegmentList<E> {
    private List<ColumnSegment<E>> edgeSegments = new ArrayList<ColumnSegment<E>>();
    private int col;
    private long minY = Integer.MAX_VALUE;
    private long maxY = Integer.MIN_VALUE;

    public ColSegmentList(int col) {
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    public ColSegmentList(ColumnSegment<E> segment) {
        this.addSegment(segment);
        this.col = 0;
    }

    public void assignOffsets() {
        List<ColSegmentList<E>> groups = this.sortIntoNonOverlappingGroups(this.edgeSegments);
        for (ColSegmentList<E> group : groups) {
            this.assignOffsets(group);
        }
    }

    boolean intersects(ColSegmentList<E> other) {
        if (this.minY > other.maxY) {
            return false;
        }
        return other.minY <= this.maxY;
    }

    ColumnSegment<E> getSegment(E edge, GridPoint startPoint) {
        for (ColumnSegment<E> edgeSegment : this.edgeSegments) {
            if (!edgeSegment.edge.equals(edge) || !edgeSegment.startsAt(startPoint)) continue;
            return edgeSegment;
        }
        return null;
    }

    public String toString() {
        return this.edgeSegments.toString();
    }

    int getMinOffset() {
        int minOffset = 0;
        for (EdgeSegment edgeSegment : this.edgeSegments) {
            minOffset = Math.min(minOffset, edgeSegment.getOffset());
        }
        return minOffset;
    }

    int getMaxOffset() {
        int maxOffset = 0;
        for (EdgeSegment edgeSegment : this.edgeSegments) {
            maxOffset = Math.max(maxOffset, edgeSegment.getOffset());
        }
        return maxOffset;
    }

    void addSegment(ColumnSegment<E> segment) {
        this.edgeSegments.add(segment);
        this.minY = Math.min(this.minY, (long)segment.getVirtualMinY());
        this.maxY = Math.max(this.maxY, (long)segment.getVirtualMaxY());
    }

    private void assignOffsets(ColSegmentList<E> group) {
        group.sort();
        int naturalCenter = this.findNaturalCenter(group);
        int centerIndex = naturalCenter >= 0 ? naturalCenter : group.edgeSegments.size() / 2;
        this.assignOffsets(group, centerIndex);
        if (naturalCenter < 0) {
            int bias = group.getMaxOffset() + group.getMinOffset();
            int adjustment = -bias / 2;
            for (EdgeSegment edgeSegment : group.edgeSegments) {
                edgeSegment.setOffset(edgeSegment.getOffset() + adjustment);
            }
        }
    }

    private void sort() {
        if (this.isUniformFlow()) {
            Collections.sort(this.edgeSegments, (s1, s2) -> s1.compareToUsingFlows(s2));
        } else {
            Collections.sort(this.edgeSegments, (s1, s2) -> s1.compareToIgnoreFlows(s2));
        }
    }

    private boolean isUniformFlow() {
        if (this.edgeSegments.isEmpty()) {
            return true;
        }
        boolean firstSegmentIsUpwardFlowing = this.edgeSegments.get(0).isFlowingUpwards();
        for (ColumnSegment<E> columnSegment : this.edgeSegments) {
            if (columnSegment.isFlowingUpwards() == firstSegmentIsUpwardFlowing) continue;
            return false;
        }
        return true;
    }

    private void assignOffsets(ColSegmentList<E> group, int center) {
        ColumnSegment<E> segment;
        int i;
        ArrayList<ColSegmentList<E>> nonOverlappingSegments = new ArrayList<ColSegmentList<E>>();
        for (i = center; i >= 0; --i) {
            segment = group.edgeSegments.get(i);
            this.assignOffsets(nonOverlappingSegments, segment, -2);
        }
        for (i = nonOverlappingSegments.size() - 1; i > 0; --i) {
            nonOverlappingSegments.remove(i);
        }
        for (i = center + 1; i < group.edgeSegments.size(); ++i) {
            segment = group.edgeSegments.get(i);
            this.assignOffsets(nonOverlappingSegments, segment, 2);
        }
    }

    private void assignOffsets(List<ColSegmentList<E>> nonOverlappingSegments, ColumnSegment<E> segment, int stepSize) {
        int i;
        for (i = nonOverlappingSegments.size() - 1; i >= 0 && !nonOverlappingSegments.get(i).hasOverlappingSegment(segment); --i) {
        }
        if (++i >= nonOverlappingSegments.size()) {
            nonOverlappingSegments.add(new ColSegmentList<E>(i));
        }
        int offset = i * stepSize;
        segment.setOffset(offset);
        nonOverlappingSegments.get(i).addSegment(segment);
    }

    private boolean hasOverlappingSegment(ColumnSegment<E> segment) {
        for (ColumnSegment<E> edgeSegment : this.edgeSegments) {
            if (!segment.overlaps(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    private int findNaturalCenter(ColSegmentList<E> group) {
        for (int i = 0; i < group.edgeSegments.size(); ++i) {
            ColumnSegment<E> edgeSegment = group.edgeSegments.get(i);
            if (edgeSegment.points.size() != 2) continue;
            return i;
        }
        return -1;
    }

    private List<ColSegmentList<E>> sortIntoNonOverlappingGroups(List<ColumnSegment<E>> segments) {
        ArrayList<ColSegmentList<E>> groups = new ArrayList<ColSegmentList<E>>(segments.size());
        for (ColumnSegment<E> segment : segments) {
            this.groupSegment(groups, segment);
        }
        return groups;
    }

    private void groupSegment(List<ColSegmentList<E>> groups, ColumnSegment<E> segment) {
        ColSegmentList<E> newGroup = new ColSegmentList<E>(segment);
        for (int i = groups.size() - 1; i >= 0; --i) {
            if (!newGroup.intersects(groups.get(i))) continue;
            newGroup.merge(groups.get(i));
            groups.remove(i);
        }
        groups.add(newGroup);
    }

    private void merge(ColSegmentList<E> segmentList) {
        this.edgeSegments.addAll(segmentList.edgeSegments);
        this.minY = Math.min(this.minY, segmentList.minY);
        this.maxY = Math.max(this.maxY, segmentList.maxY);
    }
}

