/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DBTraceObjectValPath
implements TraceObjectValPath {
    public static final DBTraceObjectValPath EMPTY = new DBTraceObjectValPath(List.of());
    private final List<DBTraceObjectValue> entryList;
    private KeyPath path;

    public static DBTraceObjectValPath of() {
        return EMPTY;
    }

    public static DBTraceObjectValPath of(Collection<DBTraceObjectValue> entryList) {
        return new DBTraceObjectValPath(List.copyOf(entryList));
    }

    public static DBTraceObjectValPath of(DBTraceObjectValue ... entries) {
        return DBTraceObjectValPath.of(Arrays.asList(entries));
    }

    private DBTraceObjectValPath(List<DBTraceObjectValue> entryList) {
        this.entryList = entryList;
    }

    @Override
    public int compareTo(TraceObjectValPath that) {
        return KeyPath.PathComparator.KEYED.compare(this.getPath(), that.getPath());
    }

    public List<DBTraceObjectValue> getEntryList() {
        return this.entryList;
    }

    protected KeyPath computePath() {
        return KeyPath.of(this.entryList.stream().map(e -> e.getEntryKey()));
    }

    @Override
    public KeyPath getPath() {
        if (this.path == null) {
            this.path = this.computePath();
        }
        return this.path;
    }

    @Override
    public boolean contains(TraceObjectValue entry) {
        return this.entryList.contains(entry);
    }

    @Override
    public DBTraceObjectValPath prepend(TraceObjectValue entry) {
        if (!this.entryList.isEmpty() && entry.getTrace() != this.entryList.get(0).getTrace()) {
            throw new IllegalArgumentException("All values in path must be from the same trace");
        }
        if (!(entry instanceof DBTraceObjectValue)) {
            throw new IllegalArgumentException("Value must be in the database");
        }
        DBTraceObjectValue val = (DBTraceObjectValue)entry;
        DBTraceObjectValue[] arr = new DBTraceObjectValue[1 + this.entryList.size()];
        arr[0] = val;
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = this.entryList.get(i - 1);
        }
        return new DBTraceObjectValPath(Collections.unmodifiableList(Arrays.asList(arr)));
    }

    @Override
    public DBTraceObjectValPath append(TraceObjectValue entry) {
        if (!this.entryList.isEmpty() && entry.getTrace() != this.entryList.get(0).getTrace()) {
            throw new IllegalArgumentException("All values in path must be from the same trace");
        }
        if (!(entry instanceof DBTraceObjectValue)) {
            throw new IllegalArgumentException("Value must be in the database");
        }
        DBTraceObjectValue val = (DBTraceObjectValue)entry;
        DBTraceObjectValue[] arr = new DBTraceObjectValue[1 + this.entryList.size()];
        for (int i = 0; i < arr.length - 1; ++i) {
            arr[i] = this.entryList.get(i);
        }
        arr[arr.length - 1] = val;
        return new DBTraceObjectValPath(Collections.unmodifiableList(Arrays.asList(arr)));
    }

    @Override
    public DBTraceObjectValue getFirstEntry() {
        if (this.entryList.isEmpty()) {
            return null;
        }
        return this.entryList.get(0);
    }

    @Override
    public TraceObject getSource(TraceObject ifEmpty) {
        DBTraceObjectValue first = this.getFirstEntry();
        return first == null ? ifEmpty : first.getParent();
    }

    @Override
    public DBTraceObjectValue getLastEntry() {
        if (this.entryList.isEmpty()) {
            return null;
        }
        return this.entryList.get(this.entryList.size() - 1);
    }

    @Override
    public Object getDestinationValue(Object ifEmpty) {
        DBTraceObjectValue last = this.getLastEntry();
        return last == null ? ifEmpty : last.getValue();
    }

    @Override
    public TraceObject getDestination(TraceObject ifEmpty) {
        DBTraceObjectValue last = this.getLastEntry();
        return last == null ? ifEmpty : last.getChild();
    }
}

