/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.lsh.vector.LSHVector;
import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class SignatureRecord {
    private LSHVector sigvector;
    private long vectorid;
    private int count;

    public SignatureRecord(LSHVector v) {
        this.sigvector = v;
        this.vectorid = 0L;
        this.count = 0;
    }

    void setVectorId(long i) {
        this.vectorid = i;
    }

    void setCount(int c) {
        this.count = c;
    }

    public LSHVector getLSHVector() {
        return this.sigvector;
    }

    public long getVectorId() {
        return this.vectorid;
    }

    public int getCount() {
        return this.count;
    }

    public void saveXml(Writer fwrite) throws IOException {
        this.sigvector.saveXml(fwrite);
    }

    public static void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory, DescriptionManager man, FunctionDescription fdesc, int count) {
        SignatureRecord srec = man.newSignature(parser, vectorFactory, count);
        man.attachSignature(fdesc, srec);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sigvector == null ? 0 : this.sigvector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignatureRecord)) {
            return false;
        }
        SignatureRecord other = (SignatureRecord)obj;
        return !(this.sigvector == null ? other.sigvector != null : !this.sigvector.equals((Object)other.sigvector));
    }
}

