/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.datatypes;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.swift.datatypes.SwiftDataTypeUtils;

public class SwiftArray
extends DemangledDataType {
    private DemangledDataType boundType;

    public SwiftArray(String mangled, String originalDemangled) {
        super(mangled, originalDemangled, "Array");
        this.setNamespace(SwiftDataTypeUtils.getSwiftNamespace());
        this.setBoundType(new DemangledDataType(mangled, originalDemangled, "undefined"));
        this.setArray(1);
    }

    public DemangledDataType getBoundType() {
        return this.boundType;
    }

    public void setBoundType(DemangledDataType type) {
        this.boundType = type;
        this.setName("Array<%s>".formatted(type.getName()));
    }
}

