/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledLabel;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftLocalDeclNameNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Object name = null;
        Long number = null;
        block6: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block6;
                }
                case Number: {
                    try {
                        number = Long.decode(child.getIndex());
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        throw new DemangledException((Exception)e);
                    }
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        if (number != null) {
            name = name + "#" + (number + 1L);
        }
        return new DemangledLabel(this.properties.mangled(), this.properties.originalDemangled(), (String)name);
    }
}

