/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import ghidra.feature.vt.api.correlator.program.DataMatchProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public class DuplicateDataMatchProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    static final String DESC = "Compares data by iterating over all defined data meeting the minimum size requirement in the source program and looking for identical byte matches in the destination program. It reports back any that have MORE THAN ONE identical match.";
    static final String DUPLICATE_MATCH = "Duplicate Data Match";

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    protected VTProgramCorrelator doCreateCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new DataMatchProgramCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options, DUPLICATE_MATCH, false);
    }

    @Override
    public String getName() {
        return DUPLICATE_MATCH;
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(DUPLICATE_MATCH);
        options.setInt("Data Minimum Size", 5);
        options.setInt("Data Maximum Size", 0x100000);
        options.setInt("Data Alignment", 1);
        options.setBoolean("Skip Homogenous Data", true);
        return options;
    }

    @Override
    public String getDescription() {
        return DESC;
    }
}

