/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.feature.vt.api.db.VTAssociationTableDBAdapter;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.framework.data.OpenMode;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class VTAssociationTableDBAdapterV0
extends VTAssociationTableDBAdapter {
    private Table table;

    public VTAssociationTableDBAdapterV0(DBHandle dbHandle) throws IOException {
        this.table = dbHandle.createTable(TABLE_NAME, TABLE_SCHEMA, TABLE_INDEXES);
    }

    public VTAssociationTableDBAdapterV0(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    DBRecord insertRecord(long sourceAddressID, long destinationAddressID, VTAssociationType type, VTAssociationStatus lockedStatus, int voteCount) throws IOException {
        DBRecord record = TABLE_SCHEMA.createRecord(this.table.getKey());
        record.setLongValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.SOURCE_ADDRESS_COL.column(), sourceAddressID);
        record.setLongValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.DESTINATION_ADDRESS_COL.column(), destinationAddressID);
        record.setByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.TYPE_COL.column(), (byte)type.ordinal());
        record.setByteValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.STATUS_COL.column(), (byte)lockedStatus.ordinal());
        record.setIntValue(VTAssociationTableDBAdapter.AssociationTableDescriptor.VOTE_COUNT_COL.column(), voteCount);
        this.table.putRecord(record);
        return record;
    }

    @Override
    void deleteRecord(long key) throws IOException {
        this.table.deleteRecord(key);
    }

    @Override
    DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    RecordIterator getRecordsForDestinationAddress(long addressId) throws IOException {
        LongField longField = new LongField(addressId);
        return this.table.indexIterator(VTAssociationTableDBAdapter.AssociationTableDescriptor.DESTINATION_ADDRESS_COL.column(), (Field)longField, (Field)longField, true);
    }

    @Override
    RecordIterator getRecordsForSourceAddress(long addressId) throws IOException {
        LongField longField = new LongField(addressId);
        return this.table.indexIterator(VTAssociationTableDBAdapter.AssociationTableDescriptor.SOURCE_ADDRESS_COL.column(), (Field)longField, (Field)longField, true);
    }

    @Override
    Set<DBRecord> getRelatedAssociationRecordsBySourceAndDestinationAddress(long sourceAddressID, long destinationAddressID) throws IOException {
        HashSet<DBRecord> recordSet = new HashSet<DBRecord>();
        RecordIterator iterator = this.getRecordsForSourceAddress(sourceAddressID);
        while (iterator.hasNext()) {
            recordSet.add(iterator.next());
        }
        iterator = this.getRecordsForDestinationAddress(destinationAddressID);
        while (iterator.hasNext()) {
            recordSet.add(iterator.next());
        }
        return recordSet;
    }

    @Override
    Set<DBRecord> getRelatedAssociationRecordsBySourceAddress(long sourceAddressID) throws IOException {
        HashSet<DBRecord> recordSet = new HashSet<DBRecord>();
        RecordIterator iterator = this.getRecordsForSourceAddress(sourceAddressID);
        while (iterator.hasNext()) {
            recordSet.add(iterator.next());
        }
        return recordSet;
    }

    @Override
    Set<DBRecord> getRelatedAssociationRecordsByDestinationAddress(long destinationAddressID) throws IOException {
        HashSet<DBRecord> recordSet = new HashSet<DBRecord>();
        RecordIterator iterator = this.getRecordsForDestinationAddress(destinationAddressID);
        while (iterator.hasNext()) {
            recordSet.add(iterator.next());
        }
        return recordSet;
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    void removeAssociaiton(long id) throws IOException {
        this.table.deleteRecord(id);
    }
}

