/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.feature.vt.api.stringable.deprecated.ParameterInfo;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;

public class ParameterStringable
extends Stringable {
    public static final String SHORT_NAME = "PARAM";
    private ParameterInfo parameterInfo;

    public ParameterStringable() {
        super(SHORT_NAME);
    }

    public ParameterStringable(Parameter parameter) {
        super(SHORT_NAME);
        this.parameterInfo = ParameterInfo.createParameterInfo(parameter);
    }

    public Parameter getParameterDefinition(Function destFunction, int ordinal) {
        return this.parameterInfo.createParameterDefinition(destFunction, ordinal);
    }

    @Override
    public String getDisplayString() {
        return this.parameterInfo.getDataType().getName() + " " + this.parameterInfo.getName();
    }

    @Override
    protected String doConvertToString(Program program) {
        return this.parameterInfo.convertToString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        this.parameterInfo = ParameterInfo.createParameterInfo(string, program);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * (this.parameterInfo == null ? 0 : this.parameterInfo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterStringable other = (ParameterStringable)obj;
        return !(this.parameterInfo == null ? other.parameterInfo != null : !this.parameterInfo.equals((Object)other.parameterInfo));
    }
}

