/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import generic.theme.GIcon;
import ghidra.feature.vt.gui.filters.AncillaryFilterDialogComponentProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.Timer;

public class FilterIconFlashTimer<T>
extends Timer
implements ActionListener {
    private static final Icon EMPTY_ICON = new GIcon("icon.version.tracking.empty");
    private static final long MINIMUM_TIME_BETWEEN_FLASHES = 20000L;
    private static final int MAX_FLASH_COUNT = 10;
    private int flashCount = 0;
    private long lastFlashTime;
    private final JButton filterButton;
    private final AncillaryFilterDialogComponentProvider<T> filterDialog;
    private final Icon baseIcon;
    private final Icon filteredIcon;

    public FilterIconFlashTimer(Icon baseIcon, Icon filteredIcon, AncillaryFilterDialogComponentProvider<T> filterDialog, JButton filterButton) {
        super(250, null);
        this.baseIcon = baseIcon;
        this.filteredIcon = filteredIcon;
        this.filterDialog = filterDialog;
        this.filterButton = filterButton;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.filterDialog.isFiltered()) {
            this.stop();
            return;
        }
        if (this.flashCount < 10) {
            this.changeIcon();
            ++this.flashCount;
        } else {
            this.stop();
            this.stallAnimation();
        }
    }

    @Override
    public void restart() {
        if (System.currentTimeMillis() - this.lastFlashTime < 20000L) {
            return;
        }
        this.flashCount = 0;
        super.restart();
    }

    @Override
    public void stop() {
        super.stop();
        this.restoreBaseIcon();
        this.flashCount = 0;
    }

    private void changeIcon() {
        Icon currentIcon = this.filterButton.getIcon();
        if (currentIcon == this.filteredIcon) {
            this.filterButton.setIcon(EMPTY_ICON);
        } else {
            this.filterButton.setIcon(this.filteredIcon);
        }
    }

    private void restoreBaseIcon() {
        if (this.filterDialog.isFiltered()) {
            this.filterButton.setIcon(this.filteredIcon);
        } else {
            this.filterButton.setIcon(this.baseIcon);
        }
    }

    private void stallAnimation() {
        this.lastFlashTime = System.currentTimeMillis();
    }
}

