/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.Tool;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgGraphType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphLabelPosition;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;
import ghidra.util.HelpLocation;

public class PCodeDfgDisplayOptions
extends GraphDisplayOptions {
    public static final String SHAPE_ATTRIBUTE = "Shape";
    private static final String BG_VERTEX_DEFAULT = "color.bg.decompiler.pcode.dfg.vertex.default";
    private static final String BG_VERTEX_SELECTED = "color.bg.decompiler.pcode.dfg.vertex.selected";
    private static final String BG_VERTEX_CONSTANT = "color.bg.decompiler.pcode.dfg.vertex.constant";
    private static final String BG_VERTEX_REGISTER = "color.bg.decompiler.pcode.dfg.vertex.register";
    private static final String BG_VERTEX_UNIQUE = "color.bg.decompiler.pcode.dfg.vertex.unique";
    private static final String BG_VERTEX_PERSISTENT = "color.bg.decompiler.pcode.dfg.vertex.persistent";
    private static final String BG_VERTEX_ADDRESS_TIED = "color.bg.decompiler.pcode.dfg.vertex.address.tied";
    private static final String BG_VERTEX_OP = "color.bg.decompiler.pcode.dfg.vertex.op";
    private static final String BG_EDGE_DEFAULT = "color.bg.decompiler.pcode.dfg.edge.default";
    private static final String BG_EDGE_SELECTED = "color.bg.decompiler.pcode.dfg.edge.selected";
    private static final String BG_EDGE_WITHIN_BLOCK = "color.bg.decompiler.pcode.dfg.edge.within.block";
    private static final String BG_EDGE_BETWEEN_BLOCKS = "color.bg.decompiler.pcode.dfg.edge.between.blocks";

    public PCodeDfgDisplayOptions(PluginTool tool) {
        super((GraphType)new PCodeDfgGraphType(), (Tool)tool, new HelpLocation("DecompilePlugin", "DataFlowGraph"));
    }

    protected void initializeDefaults() {
        this.setDefaultVertexShape(VertexShape.ELLIPSE);
        this.setDefaultVertexColor(BG_VERTEX_DEFAULT);
        this.setDefaultEdgeColor(BG_EDGE_DEFAULT);
        this.setVertexSelectionColor(BG_VERTEX_SELECTED);
        this.setEdgeSelectionColor(BG_EDGE_SELECTED);
        this.setDefaultLayoutAlgorithmName("Hierarchical MinCross Coffman Graham");
        this.setUsesIcons(false);
        this.setArrowLength(15);
        this.setLabelPosition(GraphLabelPosition.SOUTH);
        this.setVertexShapeOverrideAttributeKey(SHAPE_ATTRIBUTE);
        this.setMaxNodeCount(1000);
        this.configureVertexType(PCodeDfgGraphType.DEFAULT_VERTEX, VertexShape.ELLIPSE, BG_VERTEX_DEFAULT);
        this.configureVertexType(PCodeDfgGraphType.CONSTANT, VertexShape.ELLIPSE, BG_VERTEX_CONSTANT);
        this.configureVertexType(PCodeDfgGraphType.REGISTER, VertexShape.ELLIPSE, BG_VERTEX_REGISTER);
        this.configureVertexType(PCodeDfgGraphType.UNIQUE, VertexShape.ELLIPSE, BG_VERTEX_UNIQUE);
        this.configureVertexType(PCodeDfgGraphType.PERSISTENT, VertexShape.ELLIPSE, BG_VERTEX_PERSISTENT);
        this.configureVertexType(PCodeDfgGraphType.ADDRESS_TIED, VertexShape.ELLIPSE, BG_VERTEX_ADDRESS_TIED);
        this.configureVertexType(PCodeDfgGraphType.OP, VertexShape.ELLIPSE, BG_VERTEX_OP);
        this.configureEdgeType(PCodeDfgGraphType.DEFAULT_EDGE, BG_EDGE_DEFAULT);
        this.configureEdgeType(PCodeDfgGraphType.WITHIN_BLOCK, BG_EDGE_WITHIN_BLOCK);
        this.configureEdgeType(PCodeDfgGraphType.BETWEEN_BLOCKS, BG_EDGE_BETWEEN_BLOCKS);
        this.setFont("font.decompiler.pcode.dfg");
    }
}

