# frozen_string_literal: true

class AddDetectedAtToVulnerabilityOccurrences < Gitlab::Database::Migration[2.3]
  milestone '18.6'

  disable_ddl_transaction!

  def up
    # rubocop:disable Migration/PreventAddingColumns -- The oversized nature of this table will be addressed through planned partitioning
    with_lock_retries do
      add_column :vulnerability_occurrences, :detected_at, :timestamptz, if_not_exists: true
    end
    # rubocop:enable Migration/PreventAddingColumns
  end

  def down
    with_lock_retries do
      remove_column :vulnerability_occurrences, :detected_at, if_exists: true
    end
  end
end
