---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Contentful personal access token'
---

## Description

The response body contains content that matches the pattern of a Contentful personal access token was identified. Personal access tokens are tied to the user who requests them and carry the same permissions, including access to organizations, spaces, and content.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a personal access token:

- Sign in and visit your account profile: <https://app.contentful.com/account/profile/user>
- Select the "CMA tokens" tab in the top menu
- Identify the token that was detected
- Select "Revoke" in the right hand column
- Select "Revoke" when prompted

For more information, please see the developer [documentation on personal access tokens](https://www.contentful.com/help/token-management/personal-access-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.134 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
