import { jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { InlineField, SecretTextArea } from '@grafana/ui';
import { TLSSettingsSection } from './TLSSettingsSection.js';
import { useCommonStyles } from '../styles.js';

const SelfSignedCertificate = ({
  enabled,
  certificateConfigured,
  onToggle,
  onCertificateChange,
  onCertificateReset,
  tooltips,
  readOnly
}) => {
  var _a;
  const commonStyles = useCommonStyles();
  return /* @__PURE__ */ jsx(
    TLSSettingsSection,
    {
      enabled,
      label: "Add self-signed certificate",
      tooltipText: "Add your own Certificate Authority (CA) certificate on top of one generated by the certificate authorities for additional security measures",
      onToggle: (newEnabled) => onToggle(newEnabled),
      readOnly,
      children: /* @__PURE__ */ jsx(
        InlineField,
        {
          label: "CA Certificate",
          labelWidth: 24,
          tooltip: (_a = tooltips == null ? undefined : tooltips.certificateLabel) != null ? _a : "Your self-signed certificate",
          required: true,
          htmlFor: "self-signed-certificate-input",
          interactive: true,
          grow: true,
          className: cx(commonStyles.inlineFieldNoMarginRight, commonStyles.inlineFieldWithSecret),
          disabled: readOnly,
          children: /* @__PURE__ */ jsx(
            SecretTextArea,
            {
              id: "self-signed-certificate-input",
              isConfigured: certificateConfigured,
              onChange: (e) => onCertificateChange(e.currentTarget.value),
              onReset: readOnly ? () => {
              } : onCertificateReset,
              placeholder: "Begins with --- BEGIN CERTIFICATE ---",
              rows: 6,
              required: true
            }
          )
        }
      )
    }
  );
};

export { SelfSignedCertificate };
//# sourceMappingURL=SelfSignedCertificate.js.map
