import { jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import '@grafana/data';
import { stylesFactory, useTheme2 } from '@grafana/ui';

const Space = (props) => {
  const theme = useTheme2();
  const styles = getStyles(theme, props);
  return /* @__PURE__ */ jsx("span", { className: cx(styles.wrapper) });
};
Space.defaultProps = {
  v: 0,
  h: 0,
  layout: "block"
};
const getStyles = stylesFactory((theme, props) => {
  var _a, _b;
  return {
    wrapper: css([
      {
        paddingRight: theme.spacing((_a = props.h) != null ? _a : 0),
        paddingBottom: theme.spacing((_b = props.v) != null ? _b : 0)
      },
      props.layout === "inline" && {
        display: "inline-block"
      },
      props.layout === "block" && {
        display: "block"
      }
    ])
  };
});

export { Space };
//# sourceMappingURL=Space.js.map
