/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.de.DigraphNormalization;
import ai.grazie.rules.de.GermanCrazyParseDetector;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreeDisambiguator;
import ai.grazie.rules.de.PunctuationRules;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GermanTreeSupport
extends TreeSupport {
    private static final NodePattern lowerCase = NodePattern.N.anyPos().noPos("SUB.*|EIG.*");
    private static final NodePattern noun = NodePattern.N.pos("SUB.*").noPos(".*ADJ");

    public GermanTreeSupport(org.languagetool.Language language) {
        this(language, () -> null);
    }

    public GermanTreeSupport(org.languagetool.Language language, Supplier<@Nullable WordListWithFrequency> hunspell) {
        super(language, hunspell);
        assert (language.getShortCode().equals("de"));
    }

    @Override
    public boolean needsNer() {
        return true;
    }

    @Override
    public Tree buildTree(SentenceWithTreeDependencies conllu, @Nullable SentenceWithNERAnnotations ner, @Nullable Runnable checkCancelled) {
        return new GermanTreeDisambiguator(super.buildTree(conllu, ner, checkCancelled)).disambiguateByTree();
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return lowerCase.matches(node);
    }

    @Override
    protected Tagger createTagger() {
        return GermanTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(org.languagetool.Language language) {
        return new LTTagger(language){

            @Override
            public String normalizeToken(String token) {
                if (!token.contains("\u0308")) {
                    return token;
                }
                return token.replaceAll("a\u0308", "\u00e4").replaceAll("A\u0308", "\u00c4").replaceAll("o\u0308", "\u00f6").replaceAll("O\u0308", "\u00d6").replaceAll("u\u0308", "\u00fc").replaceAll("U\u0308", "\u00dc");
            }
        };
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        String lowLemma;
        List<String> result = super.synthesize(form, lemma, srcPos, targetPos);
        if (lemma.equals("Mensch") && !targetPos.matches(".*NOM:SIN.*")) {
            return List.of("Menschen");
        }
        if (lemma.equals("Eindruck") && targetPos.matches(".*PLU.*")) {
            result.removeIf(s -> s.startsWith("Eindruck"));
        }
        if (lemma.contains(" ")) {
            return List.of();
        }
        if ("dies".equals(lemma) && !"dies".equalsIgnoreCase(form)) {
            result.remove("dies");
        }
        if ("niemand".equals(lemma) && targetPos.matches(".*(GEN|DAT|AKK).*")) {
            result.remove("niemand");
        }
        if ("eigen".equals(lemma)) {
            result.removeIf(s -> s.contains("eign"));
        }
        if (lemma.contains("schliessen") || lemma.contains("schlie\u00dfen")) {
            result.removeIf(s -> s.contains("schlo\u00df"));
        }
        if (lemma.endsWith("schlu\u00df")) {
            return List.of();
        }
        if (lemma.equals("wissen") || lemma.equals("wi\u00dfen")) {
            result.removeIf(s -> s.contains("wi\u00dft") || s.contains("wu\u00dft"));
        }
        if (lemma.contains("fassen") || lemma.equals("fa\u00dfen")) {
            result.removeIf(s -> s.contains("fa\u00dft"));
        }
        if ((lowLemma = lemma.toLowerCase(Locale.ROOT)).endsWith("land")) {
            result.removeIf(s -> s.toLowerCase(Locale.ROOT).matches(".*landen?"));
        }
        if (lowLemma.endsWith("gang") && !lowLemma.matches("(street|jugend)gang") && targetPos.matches(".*PLU.*")) {
            result.removeIf(s -> s.toLowerCase(Locale.ROOT).matches(".+gangs"));
        }
        if (lowLemma.endsWith("thema")) {
            result.removeIf(s -> s.toLowerCase(Locale.ROOT).endsWith("themata"));
        }
        if (lowLemma.matches("(lese)?eck")) {
            return List.of();
        }
        String lowForm = form.toLowerCase(Locale.ROOT);
        if (lowForm.matches("ich|mi(r|ch)")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("ich|mi(r|ch)"));
        }
        if (lowForm.matches("du|di(r|ch)")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("du|di(r|ch)"));
            if (result.contains("dir")) {
                result.remove("Dir");
            }
        }
        if (lowForm.matches("e[rs]|ih[mn]")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("e[rs]|ih[mn]"));
        }
        if (lowForm.matches("sie|ihnen")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("sie|i(hr|hnen)"));
        }
        if (lowForm.matches("wir|uns")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("wir|uns"));
        }
        if (lowForm.matches("euch")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("ihr|euch"));
        }
        if (lowForm.matches("mein(e[mnsr]?)?")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("mein"));
        }
        if (lowForm.matches("dein(e[mnsr]?)?")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("dein"));
        }
        if (lowForm.matches("sein(e[mnsr]?)?") && targetPos.matches("PRO.*")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("sein"));
        }
        if (lowForm.matches("unser(e[mnsr]?)?")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("unser"));
        }
        if (lowForm.matches("eue?r(e[mnsr]?)?")) {
            result.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("eu"));
        }
        if (form.matches("Ihr(e[mnsr])?")) {
            result.removeIf(s -> !s.startsWith("Ihr"));
        }
        if (form.matches("ihr")) {
            result.removeIf(s -> !s.matches("ihnen|sie|ihr(e[mnsr]?)?"));
        }
        if (form.matches("(?iu)all(e.?)?") && !"all".equals(lemma)) {
            result.addAll(super.synthesize(form, "all", srcPos, targetPos));
        }
        if (form.matches("eur(e.?)?")) {
            result.removeIf(s -> s.startsWith("euer"));
        }
        if (targetPos.matches(".*DAT:SIN.*")) {
            result.removeIf(s -> s.equals(lemma + "e") || lemma.endsWith("s") && s.equals(lemma + "se"));
        }
        if (targetPos.matches("VER.*:1:SIN:PR\u00c4.*") && !lemma.matches("sein|wissen|m\u00fcssen|d\u00fcrfen|sollen|m\u00f6gen|k\u00f6nnen|wollen")) {
            result.removeIf(s -> !s.endsWith("e"));
        }
        if (lemma.equals("Ideale")) {
            return List.of();
        }
        if (lemma.endsWith("erer")) {
            if (targetPos.matches(".*GEN:SIN.*")) {
                return List.of(lemma + "s");
            }
            if (targetPos.matches(".*DAT:PLU.*")) {
                return List.of(lemma + "n");
            }
            return List.of(lemma);
        }
        if (lemma.matches(".*[Mm]odul")) {
            if (srcPos.endsWith("NEU")) {
                if (targetPos.contains("DAT:PLU")) {
                    return List.of(lemma + "en");
                }
                if (targetPos.contains(":PLU")) {
                    return List.of(lemma + "e");
                }
            }
            if (srcPos.endsWith("MAS") && targetPos.contains("PLU")) {
                return List.of(lemma + "n");
            }
        }
        if (targetPos.matches(".*GEN:SIN:(MAS|NEU).*") && result.size() == 2 && result.containsAll(List.of(lemma + "es", lemma + "s"))) {
            if (lemma.matches(".+[aeiou][bcdfgjklmnpqrstvwxz]{2}") && !lemma.matches(".+(r[gt]|[ln]d|xt|tz|pf)") && !lemma.matches("(M|.*m)ann|(F|.*f)reund") || lemma.matches(".*[GBgb]e.+[aeiou\u00e4\u00f6\u00fc]cht?") || lemma.matches(".+[aeiou]h?") || lemma.matches("(A([bn]|u[fs])|Bei|Ein|Fest|Fort|Gegen|H(in|er)|Mit|Nach|(\u00dcb|Unt)er|Um|Vor|Wider|Zu(r\u00fcck|sammen)).+") || lemma.matches(".+((f|ph)on|t[au]t|nth|t[eo]m|sal)") || lemma.matches(".+(ei|au)[bcdfgjklmnpqrstvwxz]") || lemma.matches(".*([rR]oman|[dD]om|[tT]ermin|[bB]eruf|[aA]ngebot)")) {
                result.removeIf(s -> s.equals(lemma + "es"));
            } else {
                result.removeIf(s -> s.equals(lemma + "s"));
            }
        }
        result.remove("Lohnn");
        return result;
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return GermanCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text) {
        return "\u201e" + text + "\u201c";
    }

    @Override
    public Quotes getAllQuotes() {
        return PunctuationRules.genericQuotes;
    }

    @Override
    protected boolean shouldPreserveCase(TextChange.Replacement change, Tree tree, String prevText) {
        Node firstNode = tree.findNodeAt(change.range().start());
        return super.shouldPreserveCase(change, tree, prevText) && !noun.matches(firstNode) && (firstNode == null || firstNode.form().length() >= prevText.length() || !prevText.equalsIgnoreCase(change.replacement()));
    }

    @Override
    public List<String> inflectNode(Node node, @Language(value="RegExp") String posRegex, String posReplacement) {
        String variant;
        Pattern posPattern = Pattern.compile(posRegex);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Tree.Token readings = this.tagToken(node.form());
        boolean isSwiss = GermanParameters.VARIANT.getValue(node.tree()).equals("CH");
        if (readings.tokenReadings().isEmpty() && isSwiss && (variant = (String)DigraphNormalization.generateCombinations(node.form(), Map.of("ss", "\u00df")).stream().filter(c -> node.tree().treeSupport().isAcceptedBySpellchecker((String)c)).findFirst().orElse(null)) != null && !variant.equals(node.form())) {
            readings = this.tagToken(variant);
        }
        for (Tree.Reading reading : readings.tokenReadings()) {
            Matcher matcher;
            String posTag = reading.pos();
            String lemma = reading.lemma();
            if (posTag == null || lemma == null || !(matcher = posPattern.matcher(posTag)).matches()) continue;
            String targetPos = matcher.replaceAll(posReplacement);
            result.addAll(this.synthesize(node.form(), lemma, posTag, targetPos).stream().map(v -> isSwiss ? v.replaceAll("\u00df", "ss") : v).toList());
        }
        return new ArrayList<String>(result);
    }

    @Override
    protected Tree disambiguateWithParameters(Tree tree) {
        if (!GermanParameters.VARIANT.getValue(tree).equals("CH")) {
            return tree;
        }
        TreeSupport support = tree.treeSupport();
        for (Node dep : tree.nodes()) {
            String variant;
            if (!dep.lemmaReadings().isEmpty() || !dep.form().contains("ss") || (variant = (String)DigraphNormalization.generateCombinations(dep.form(), Map.of("ss", "\u00df")).stream().filter(c -> support.isAcceptedBySpellchecker((String)c)).findFirst().orElse(null)) == null || variant.equals(dep.form())) continue;
            tree = tree.withReadings(dep, tree.treeSupport().tagToken(variant).tokenReadings());
        }
        return tree;
    }
}

