/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.ConfigurableGradleBuildIssue;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b'\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0015\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003J?\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "dependencyName", "", "dependencyOwner", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "buildDescription", "Lcom/intellij/openapi/util/NlsSafe;", "failureMessage", "configureQuickFix", "", "isOfflineMode", "", "offlineModeQuickFixText", "projectPath", "requiredGradleJVM", "", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "addGradleJvmOrNewerQuickFix", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public abstract class UnresolvedDependencyIssue
extends ConfigurableGradleBuildIssue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String dependencyOwner;
    @NotNull
    public static final String offlineQuickFixId = "disable_offline_mode";
    @NotNull
    private static final String declaringRepositoriesLink = "https://docs.gradle.org/current/userguide/declaring_repositories.html";

    public UnresolvedDependencyIssue(@NotNull String dependencyName, @Nullable String dependencyOwner) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        this.dependencyOwner = dependencyOwner;
        if (this.dependencyOwner == null) {
            var4_3 = new Object[]{dependencyName};
            string = GradleBundle.message("gradle.build.issue.unresolved.dependency.title", var4_3);
        } else {
            var4_3 = new Object[]{dependencyName, this.dependencyOwner};
            string = GradleBundle.message("gradle.build.issue.unresolved.dependency.for.owner.title", var4_3);
        }
        String title = string;
        Intrinsics.checkNotNull((Object)title);
        this.setTitle(title);
    }

    public /* synthetic */ UnresolvedDependencyIssue(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public final String buildDescription(@Nullable String failureMessage) {
        StringBuilder issueDescription = new StringBuilder();
        if (this.dependencyOwner != null) {
            issueDescription.append(this.dependencyOwner);
            issueDescription.append(": ");
        }
        String string = failureMessage;
        issueDescription.append(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null);
        String string2 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final void configureQuickFix(@Nullable String failureMessage, boolean isOfflineMode, @Nls @NotNull String offlineModeQuickFixText, @Nullable String projectPath, @Nullable Integer requiredGradleJVM) {
        Intrinsics.checkNotNullParameter((Object)offlineModeQuickFixText, (String)"offlineModeQuickFixText");
        String string = failureMessage;
        boolean noRepositoriesDefined = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"no repositories are defined", (boolean)false, (int)2, null) : false;
        if (projectPath != null && requiredGradleJVM != null) {
            this.addGradleJvmOrNewerQuickFix(projectPath, requiredGradleJVM);
        } else if (isOfflineMode && !noRepositoriesDefined) {
            this.addQuickFixPrompt(offlineModeQuickFixText);
        } else {
            Object[] objectArray = new Object[]{declaringRepositoriesLink};
            String string2 = GradleBundle.message("gradle.build.quick.fix.artifact.declare.repository", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.addQuickFixPrompt(string2);
        }
    }

    public static /* synthetic */ void configureQuickFix$default(UnresolvedDependencyIssue unresolvedDependencyIssue, String string, boolean bl, String string2, String string3, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureQuickFix");
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        unresolvedDependencyIssue.configureQuickFix(string, bl, string2, string3, n);
    }

    private final void addGradleJvmOrNewerQuickFix(String projectPath, int requiredGradleJVM) {
        if (Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            return;
        }
        JavaVersion javaVersion = JavaVersion.Companion.compose$default((JavaVersion.Companion)JavaVersion.Companion, (int)requiredGradleJVM, (int)0, (int)0, (int)0, (boolean)false, (int)30, null);
        GradleSettingsQuickFix quickFix = new GradleSettingsQuickFix(projectPath, true, GradleSettingsQuickFix.GradleJvmChangeDetector.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference, javaVersion};
        String string = GradleBundle.message("gradle.build.quick.fix.gradle.jvm.or.newer", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue$Companion;", "", "<init>", "()V", "offlineQuickFixId", "", "declaringRepositoriesLink", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

