/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.codeInsight.hierarchy.HierarchyViewTestFixture;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyViewTestBase
extends DaemonAnalyzerTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String groovyJar = PathManager.getJarPathForClass(GroovyObject.class);
        if (groovyJar != null) {
            VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{groovyJar});
        }
    }

    protected abstract String getBasePath();

    protected void doHierarchyTest(@NotNull Supplier<? extends HierarchyTreeStructure> treeStructure, @Nullable Comparator<? super NodeDescriptor<?>> comparator, String ... fileNames) throws IOException {
        if (treeStructure == null) {
            HierarchyViewTestBase.$$$reportNull$$$0(0);
        }
        if (fileNames == null) {
            HierarchyViewTestBase.$$$reportNull$$$0(1);
        }
        this.configure(fileNames);
        String verificationFilePath = this.getTestDataPath() + "/" + this.getBasePath() + "/verification.xml";
        HierarchyViewTestFixture.doHierarchyTest(treeStructure.get(), comparator, new File(verificationFilePath));
    }

    private void configure(String @NotNull [] fileNames) {
        if (fileNames == null) {
            HierarchyViewTestBase.$$$reportNull$$$0(2);
        }
        String[] relFilePaths = new String[fileNames.length];
        for (int i2 = 0; i2 < fileNames.length; ++i2) {
            relFilePaths[i2] = "/" + this.getBasePath() + "/" + fileNames[i2];
        }
        this.configureByFiles(null, relFilePaths);
        ExpectedHighlightingData expectedHighlightingData = new ExpectedHighlightingData(this.myEditor.getDocument(), false, false, false);
        this.checkHighlighting(expectedHighlightingData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doHierarchyTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

