/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictNotificationPanel
extends EditorNotificationPanel {
    @Nullable
    public static ChangelistConflictNotificationPanel create(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        ChangeListManager manager;
        Change change;
        if (project == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(2);
        }
        if ((change = (manager = ChangeListManager.getInstance((Project)project)).getChange(file)) == null) {
            return null;
        }
        LocalChangeList changeList = manager.getChangeList(change);
        if (changeList == null) {
            return null;
        }
        return new ChangelistConflictNotificationPanel(project, file, fileEditor, changeList);
    }

    private ChangelistConflictNotificationPanel(final @NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull LocalChangeList changeList) {
        if (project == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(4);
        }
        if (fileEditor == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(5);
        }
        if (changeList == null) {
            ChangelistConflictNotificationPanel.$$$reportNull$$$0(6);
        }
        super(fileEditor, EditorNotificationPanel.Status.Warning);
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        this.myLabel.setText(VcsBundle.message((String)"changes.file.from.non.active.changelist.is.modified", (Object[])new Object[0]));
        this.createActionLabel(VcsBundle.message((String)"link.label.move.changes", (Object[])new Object[0]), () -> ChangelistConflictResolution.MOVE.resolveConflict(project, changeList.getChanges(), file)).setToolTipText(VcsBundle.message((String)"changes.move.changes.to.active.change.list.name", (Object[])new Object[]{manager.getDefaultChangeList().getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.switch.changelist", (Object[])new Object[0]), () -> ChangeListManager.getInstance((Project)project).setDefaultChangeList(changeList)).setToolTipText(VcsBundle.message((String)"changes.set.active.changelist.to.change.list.name", (Object[])new Object[]{changeList.getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.ignore", (Object[])new Object[0]), () -> ChangelistConflictTracker.getInstance(project).ignoreConflict(file, true)).setToolTipText(VcsBundle.message((String)"changes.hide.this.notification", (Object[])new Object[0]));
        this.myLinksPanel.add((Component)new InplaceButton(VcsBundle.message((String)"tooltip.show.options.dialog", (Object[])new Object[0]), AllIcons.General.Settings, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, ChangelistConflictConfigurable.class);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

