/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectJavaClassFinderKt;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClass;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClassFinderKt;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInsResourceLoader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0018H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectKotlinClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/ClassLoader;)V", "builtInsResourceLoader", "Lorg/jetbrains/kotlin/serialization/deserialization/builtins/BuiltInsResourceLoader;", "findKotlinClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "fqName", "", "findKotlinClassOrContent", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findMetadata", "Ljava/io/InputStream;", "findMetadataTopLevelClassesInPackage", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasMetadataPackage", "", "findBuiltInsData", "descriptors.runtime"})
@SourceDebugExtension(value={"SMAP\nReflectKotlinClassFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectKotlinClassFinder.kt\norg/jetbrains/kotlin/descriptors/runtime/components/ReflectKotlinClassFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class ReflectKotlinClassFinder
implements KotlinClassFinder {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final BuiltInsResourceLoader builtInsResourceLoader;

    public ReflectKotlinClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.builtInsResourceLoader = new BuiltInsResourceLoader();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KotlinClassFinder.Result findKotlinClass(String fqName) {
        KotlinClassFinder.Result.KotlinClass kotlinClass;
        Class<?> clazz = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, fqName);
        if (clazz != null) {
            Class<?> it = clazz;
            boolean bl = false;
            ReflectKotlinClass reflectKotlinClass = ReflectKotlinClass.Factory.create(it);
            clazz = reflectKotlinClass;
            if (reflectKotlinClass != null) {
                KotlinJvmBinaryClass p0 = (KotlinJvmBinaryClass)clazz;
                boolean bl2 = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
                return (KotlinClassFinder.Result)kotlinClass;
            }
        }
        kotlinClass = null;
        return (KotlinClassFinder.Result)kotlinClass;
    }

    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        return this.findKotlinClass(ReflectKotlinClassFinderKt.access$toRuntimeFqName(classId));
    }

    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Object object = javaClass.getFqName();
        if (object == null || (object = object.asString()) == null) {
            return null;
        }
        return this.findKotlinClass((String)object);
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return null;
    }

    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return false;
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        if (!packageFqName.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        return this.builtInsResourceLoader.loadResource(BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(packageFqName));
    }
}

