/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.SwitchPoint;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.runtime.opto.Invalidator;

public class SwitchPointInvalidator
implements Invalidator {
    private static final SwitchPoint DUMMY = new SwitchPoint();
    private volatile SwitchPoint switchPoint = DUMMY;

    @Override
    public synchronized void invalidate() {
        if (this.switchPoint == DUMMY) {
            return;
        }
        SwitchPoint.invalidateAll(new SwitchPoint[]{this.switchPoint});
        this.switchPoint = DUMMY;
    }

    @Override
    public void invalidateAll(List<Invalidator> invalidators) {
        if (invalidators.isEmpty()) {
            return;
        }
        SwitchPoint[] switchPoints = new SwitchPoint[invalidators.size()];
        for (int i2 = 0; i2 < invalidators.size(); ++i2) {
            Invalidator invalidator = invalidators.get(i2);
            assert (invalidator instanceof SwitchPointInvalidator);
            switchPoints[i2] = ((SwitchPointInvalidator)invalidator).replaceSwitchPoint();
        }
        SwitchPoint.invalidateAll(switchPoints);
    }

    @Override
    public synchronized Object getData() {
        SwitchPoint switchPoint = this.switchPoint;
        return switchPoint == DUMMY ? (this.switchPoint = new SwitchPoint()) : switchPoint;
    }

    public synchronized SwitchPoint replaceSwitchPoint() {
        SwitchPoint switchPoint = this.switchPoint;
        if (switchPoint == DUMMY) {
            return switchPoint;
        }
        SwitchPoint oldSwitchPoint = switchPoint;
        this.switchPoint = DUMMY;
        return oldSwitchPoint;
    }

    @Override
    public void addIfUsed(RubyModule.InvalidatorList invalidators) {
        if (this.switchPoint != DUMMY) {
            invalidators.add(this);
        }
    }

    static {
        SwitchPoint.invalidateAll(new SwitchPoint[]{DUMMY});
    }
}

