/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class ByteArrayUtil {
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle CHAR_HANDLE = MethodHandles.byteArrayViewVarHandle(char[].class, ByteOrder.LITTLE_ENDIAN);

    private ByteArrayUtil() {
    }

    public static char getChar(byte[] b, int off) {
        return CHAR_HANDLE.get(b, off);
    }

    public static short getShort(byte[] b, int off) {
        return SHORT_HANDLE.get(b, off);
    }

    public static int getInt(byte[] b, int off) {
        return INT_HANDLE.get(b, off);
    }

    public static long getLong(byte[] b, int off) {
        return LONG_HANDLE.get(b, off);
    }

    public static void setLong(byte[] b, int off, long v) {
        LONG_HANDLE.set(b, off, v);
    }

    public static void setInt(byte[] b, int off, int v) {
        INT_HANDLE.set(b, off, v);
    }

    public static void setShort(byte[] b, int off, short v) {
        SHORT_HANDLE.set(b, off, v);
    }

    public static long getLong(CharSequence charSequence, int off) {
        return (long)charSequence.charAt(off) | (long)charSequence.charAt(off + 1) << 16 | (long)charSequence.charAt(off + 2) << 32 | (long)charSequence.charAt(off + 3) << 48;
    }

    public static int getInt(CharSequence charSequence, int off) {
        return charSequence.charAt(off) | charSequence.charAt(off + 1) << 16;
    }

    public static void setChar(byte[] b, int off, char v) {
        CHAR_HANDLE.set(b, off, v);
    }

    public static void copyCharsToByteArray(CharSequence charSequence, int offetCharSequence, byte[] byteArray, int offsetByteArray, int numChars) {
        int charIdx;
        for (charIdx = 0; charIdx <= numChars - 4; charIdx += 4) {
            ByteArrayUtil.setLong(byteArray, offsetByteArray + (charIdx << 1), ByteArrayUtil.getLong(charSequence, offetCharSequence + charIdx));
        }
        if ((numChars & 2) != 0) {
            charIdx = numChars & 0xFFFFFFFC;
            ByteArrayUtil.setInt(byteArray, offsetByteArray + (charIdx << 1), ByteArrayUtil.getInt(charSequence, offetCharSequence + charIdx));
        }
        if ((numChars & 1) != 0) {
            charIdx = numChars & 0xFFFFFFFE;
            ByteArrayUtil.setChar(byteArray, offsetByteArray + (charIdx << 1), charSequence.charAt(offetCharSequence + charIdx));
        }
    }
}

