/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.metadata.LeaderRecoveryState;

public class LeaderAndIsr {
    public static final int INITIAL_LEADER_EPOCH = 0;
    public static final int INITIAL_PARTITION_EPOCH = 0;
    public static final int NO_LEADER = -1;
    private final int leader;
    private final int leaderEpoch;
    private final LeaderRecoveryState leaderRecoveryState;
    private final List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch;
    private final int partitionEpoch;

    public LeaderAndIsr(int leader, List<Integer> isr) {
        this(leader, 0, isr, LeaderRecoveryState.RECOVERED, 0);
    }

    public LeaderAndIsr(int leader, int leaderEpoch, List<Integer> isr, LeaderRecoveryState leaderRecoveryState, int partitionEpoch) {
        this(leader, leaderEpoch, leaderRecoveryState, isr.stream().map(brokerId -> new AlterPartitionRequestData.BrokerState().setBrokerId(brokerId.intValue())).toList(), partitionEpoch);
    }

    public LeaderAndIsr(int leader, int leaderEpoch, LeaderRecoveryState leaderRecoveryState, List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch, int partitionEpoch) {
        this.leader = leader;
        this.leaderEpoch = leaderEpoch;
        this.leaderRecoveryState = leaderRecoveryState;
        this.isrWithBrokerEpoch = isrWithBrokerEpoch;
        this.partitionEpoch = partitionEpoch;
    }

    public int leader() {
        return this.leader;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch() {
        return this.isrWithBrokerEpoch;
    }

    public LeaderRecoveryState leaderRecoveryState() {
        return this.leaderRecoveryState;
    }

    public int partitionEpoch() {
        return this.partitionEpoch;
    }

    public LeaderAndIsr withPartitionEpoch(int partitionEpoch) {
        return new LeaderAndIsr(this.leader, this.leaderEpoch, this.leaderRecoveryState, this.isrWithBrokerEpoch, partitionEpoch);
    }

    public LeaderAndIsr newLeader(int leader) {
        return this.newLeaderAndIsrWithBrokerEpoch(leader, this.isrWithBrokerEpoch);
    }

    public LeaderAndIsr newLeaderAndIsr(int leader, List<Integer> isr) {
        return new LeaderAndIsr(leader, this.leaderEpoch + 1, isr, this.leaderRecoveryState, this.partitionEpoch);
    }

    private LeaderAndIsr newLeaderAndIsrWithBrokerEpoch(int leader, List<AlterPartitionRequestData.BrokerState> isrWithBrokerEpoch) {
        return new LeaderAndIsr(leader, this.leaderEpoch + 1, this.leaderRecoveryState, isrWithBrokerEpoch, this.partitionEpoch);
    }

    public LeaderAndIsr newRecoveringLeaderAndIsr(int leader, List<Integer> isr) {
        return new LeaderAndIsr(leader, this.leaderEpoch + 1, isr, LeaderRecoveryState.RECOVERING, this.partitionEpoch);
    }

    public LeaderAndIsr newEpoch() {
        return this.newLeaderAndIsrWithBrokerEpoch(this.leader, this.isrWithBrokerEpoch);
    }

    public Optional<Integer> leaderOpt() {
        return this.leader == -1 ? Optional.empty() : Optional.of(this.leader);
    }

    public Set<Integer> isr() {
        return this.isrWithBrokerEpoch.stream().map(AlterPartitionRequestData.BrokerState::brokerId).collect(Collectors.toUnmodifiableSet());
    }

    public String toString() {
        return "LeaderAndIsr(leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isrWithBrokerEpoch=" + String.valueOf(this.isrWithBrokerEpoch) + ", leaderRecoveryState=" + String.valueOf((Object)this.leaderRecoveryState) + ", partitionEpoch=" + this.partitionEpoch + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderAndIsr that = (LeaderAndIsr)o;
        return this.leader == that.leader && this.leaderEpoch == that.leaderEpoch && this.partitionEpoch == that.partitionEpoch && this.leaderRecoveryState == that.leaderRecoveryState && Objects.equals(this.isrWithBrokerEpoch, that.isrWithBrokerEpoch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leader, this.leaderEpoch, this.leaderRecoveryState, this.isrWithBrokerEpoch, this.partitionEpoch});
    }
}

